/*
 * Decompiled with CFR 0.152.
 */
package org.geant.idpextension.oidc.profile.context.navigate;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.profile.config.ProfileConfiguration;
import net.shibboleth.utilities.java.support.component.AbstractIdentifiableInitializableComponent;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.messaging.context.navigate.ContextDataLookupFunction;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProfileResponderIdLookupFunction
extends AbstractIdentifiableInitializableComponent
implements ContextDataLookupFunction<ProfileRequestContext, String> {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(ProfileResponderIdLookupFunction.class);
    @Nonnull
    private String defaultResponder;
    @Nonnull
    private Map<String, String> profileResponders = new HashMap<String, String>();

    public void setDefaultResponder(@Nonnull String resp) {
        this.defaultResponder = (String)Constraint.isNotNull((Object)resp, (String)"Default responder cannot be null");
    }

    public void setProfileResponders(@Nullable Map<ProfileConfiguration, String> resp) {
        this.profileResponders.clear();
        if (resp != null) {
            for (Map.Entry<ProfileConfiguration, String> entry : resp.entrySet()) {
                if (entry.getKey() == null || entry.getKey().getId() == null || entry.getValue() == null) continue;
                this.profileResponders.put(entry.getKey().getId(), entry.getValue());
            }
        }
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.defaultResponder == null) {
            throw new ComponentInitializationException("Default responder cannot be null");
        }
    }

    @Nullable
    public String apply(@Nullable ProfileRequestContext input) {
        if (this.profileResponders.containsKey(input.getProfileId())) {
            return this.profileResponders.get(input.getProfileId());
        }
        return this.defaultResponder;
    }
}

