/*
 * Decompiled with CFR 0.152.
 */
package org.geant.idpextension.oidc.token.support;

import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.openid.connect.sdk.claims.ACR;
import java.text.ParseException;
import java.time.Instant;
import javax.annotation.Nonnull;
import net.shibboleth.utilities.java.support.security.DataSealer;
import net.shibboleth.utilities.java.support.security.DataSealerException;
import org.geant.idpextension.oidc.token.support.TokenClaimsSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RefreshTokenClaimsSet
extends TokenClaimsSet {
    private static final String VALUE_TYPE_RF = "rf";
    @Nonnull
    private Logger log = LoggerFactory.getLogger(RefreshTokenClaimsSet.class);

    public RefreshTokenClaimsSet(@Nonnull TokenClaimsSet tokenClaimsSet, @Nonnull Instant iat, @Nonnull Instant exp) {
        super(VALUE_TYPE_RF, tokenClaimsSet.getID(), tokenClaimsSet.getClientID(), tokenClaimsSet.getClaimsSet().getIssuer(), tokenClaimsSet.getPrincipal(), tokenClaimsSet.getClaimsSet().getSubject(), tokenClaimsSet.getACR() == null ? null : new ACR(tokenClaimsSet.getACR()), iat, exp, tokenClaimsSet.getNonce(), tokenClaimsSet.getAuthenticationTime(), tokenClaimsSet.getRedirectURI(), tokenClaimsSet.getScope(), tokenClaimsSet.getClaimsRequest(), tokenClaimsSet.getDeliveryClaims(), null, tokenClaimsSet.getUserinfoDeliveryClaims(), tokenClaimsSet.getConsentableClaims(), tokenClaimsSet.getConsentedClaims(), null);
    }

    private RefreshTokenClaimsSet(JWTClaimsSet refreshTokenClaimsSet) {
        this.tokenClaimsSet = refreshTokenClaimsSet;
    }

    public static RefreshTokenClaimsSet parse(String refreshTokenClaimsSet) throws ParseException {
        JWTClaimsSet atClaimsSet = JWTClaimsSet.parse((String)refreshTokenClaimsSet);
        RefreshTokenClaimsSet.verifyParsedClaims(VALUE_TYPE_RF, atClaimsSet);
        return new RefreshTokenClaimsSet(atClaimsSet);
    }

    public static RefreshTokenClaimsSet parse(@Nonnull String wrappedAccessToken, @Nonnull DataSealer dataSealer) throws ParseException, DataSealerException {
        return RefreshTokenClaimsSet.parse(dataSealer.unwrap(wrappedAccessToken));
    }
}

