/*
 * Decompiled with CFR 0.152.
 */
package org.geant.idpextension.oauth2.decoding.impl;

import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.TokenIntrospectionRequest;
import com.nimbusds.oauth2.sdk.http.HTTPRequest;
import com.nimbusds.oauth2.sdk.http.ServletUtils;
import java.io.IOException;
import javax.annotation.Nonnull;
import javax.servlet.http.HttpServletRequest;
import org.geant.idpextension.oidc.decoding.impl.RequestUtil;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.decoder.MessageDecodingException;
import org.opensaml.messaging.decoder.servlet.AbstractHttpServletRequestMessageDecoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OAuth2IntrospectionRequestDecoder
extends AbstractHttpServletRequestMessageDecoder {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(OAuth2IntrospectionRequestDecoder.class);

    protected void doDecode() throws MessageDecodingException {
        MessageContext messageContext = new MessageContext();
        TokenIntrospectionRequest req = null;
        try {
            HTTPRequest httpReq = ServletUtils.createHTTPRequest((HttpServletRequest)this.getHttpServletRequest());
            this.log.debug("Inbound request {}", (Object)RequestUtil.toString(httpReq));
            req = TokenIntrospectionRequest.parse((HTTPRequest)httpReq);
        }
        catch (ParseException | IOException e) {
            this.log.error("Unable to decode inbound request: {}", (Object)e.getMessage());
            throw new MessageDecodingException((Exception)e);
        }
        messageContext.setMessage((Object)req);
        this.setMessageContext(messageContext);
    }
}

