/*
 * Decompiled with CFR 0.152.
 */
package org.geant.idpextension.oauth2.profile.impl;

import com.nimbusds.oauth2.sdk.TokenIntrospectionRequest;
import com.nimbusds.oauth2.sdk.TokenIntrospectionSuccessResponse;
import com.nimbusds.oauth2.sdk.id.Issuer;
import com.nimbusds.oauth2.sdk.id.Subject;
import com.nimbusds.oauth2.sdk.token.AccessTokenType;
import java.text.ParseException;
import javax.annotation.Nonnull;
import net.shibboleth.utilities.java.support.annotation.ParameterName;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullAfterInit;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.security.DataSealer;
import net.shibboleth.utilities.java.support.security.DataSealerException;
import org.geant.idpextension.oidc.profile.impl.AbstractOIDCRequestAction;
import org.geant.idpextension.oidc.storage.RevocationCache;
import org.geant.idpextension.oidc.storage.RevocationCacheContexts;
import org.geant.idpextension.oidc.token.support.AccessTokenClaimsSet;
import org.geant.idpextension.oidc.token.support.RefreshTokenClaimsSet;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FormOutboundIntrospectionResponseMessage
extends AbstractOIDCRequestAction<TokenIntrospectionRequest> {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(FormOutboundIntrospectionResponseMessage.class);
    @Nonnull
    private final DataSealer dataSealer;
    @NonnullAfterInit
    private RevocationCache revocationCache;

    public FormOutboundIntrospectionResponseMessage(@Nonnull @ParameterName(name="sealer") DataSealer sealer) {
        this.dataSealer = (DataSealer)Constraint.isNotNull((Object)sealer, (String)"DataSealer cannot be null");
    }

    public void setRevocationCache(@Nonnull RevocationCache cache) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.revocationCache = (RevocationCache)Constraint.isNotNull((Object)cache, (String)"RevocationCache cannot be null");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        Constraint.isNotNull((Object)this.revocationCache, (String)"RevocationCache cannot be null");
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        AccessTokenClaimsSet tokenClaimsSet = null;
        AccessTokenType tokenType = null;
        this.log.debug("{} token to introspect {}", (Object)this.getLogPrefix(), (Object)((TokenIntrospectionRequest)this.getRequest()).getToken().getValue());
        try {
            tokenClaimsSet = AccessTokenClaimsSet.parse((String)((TokenIntrospectionRequest)this.getRequest()).getToken().getValue(), (DataSealer)this.dataSealer);
            tokenType = AccessTokenType.BEARER;
            this.log.debug("{} access token unwrapped {}", (Object)this.getLogPrefix(), (Object)tokenClaimsSet.serialize());
        }
        catch (ParseException | DataSealerException e) {
            this.log.debug("{} token to introspect is not valid access token", (Object)this.getLogPrefix());
        }
        if (tokenClaimsSet == null) {
            try {
                tokenClaimsSet = RefreshTokenClaimsSet.parse((String)((TokenIntrospectionRequest)this.getRequest()).getToken().getValue(), (DataSealer)this.dataSealer);
                this.log.debug("{} refresh token unwrapped {}", (Object)this.getLogPrefix(), (Object)tokenClaimsSet.serialize());
            }
            catch (ParseException | DataSealerException e) {
                this.log.debug("{} token to introspect is not valid refresh token", (Object)this.getLogPrefix());
            }
        }
        if (tokenClaimsSet == null) {
            this.log.debug("{} unable to decode token", (Object)this.getLogPrefix());
            profileRequestContext.getOutboundMessageContext().setMessage((Object)new TokenIntrospectionSuccessResponse.Builder(false).build());
            return;
        }
        if (this.revocationCache.isRevoked(RevocationCacheContexts.AUTHORIZATION_CODE, tokenClaimsSet.getID())) {
            this.log.debug("{} tokens derived from authorization code {} are all revoked", (Object)this.getLogPrefix(), (Object)tokenClaimsSet.getID());
            profileRequestContext.getOutboundMessageContext().setMessage((Object)new TokenIntrospectionSuccessResponse.Builder(false).build());
            return;
        }
        if (tokenClaimsSet.isExpired()) {
            this.log.debug("{} tokens is expired", (Object)this.getLogPrefix(), (Object)tokenClaimsSet.getID());
            profileRequestContext.getOutboundMessageContext().setMessage((Object)new TokenIntrospectionSuccessResponse.Builder(false).build());
            return;
        }
        profileRequestContext.getOutboundMessageContext().setMessage((Object)new TokenIntrospectionSuccessResponse.Builder(true).scope(tokenClaimsSet.getScope()).clientID(tokenClaimsSet.getClientID()).username(tokenClaimsSet.getPrincipal()).tokenType(tokenType).expirationTime(tokenClaimsSet.getClaimsSet().getExpirationTime()).issueTime(tokenClaimsSet.getClaimsSet().getIssueTime()).subject(new Subject(tokenClaimsSet.getClaimsSet().getSubject())).issuer(new Issuer(tokenClaimsSet.getClaimsSet().getIssuer())).build());
    }
}

