/*
 * Decompiled with CFR 0.152.
 */
package org.geant.idpextension.oauth2.profile.impl;

import com.nimbusds.oauth2.sdk.TokenRevocationRequest;
import java.text.ParseException;
import javax.annotation.Nonnull;
import net.shibboleth.utilities.java.support.annotation.ParameterName;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullAfterInit;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.security.DataSealer;
import net.shibboleth.utilities.java.support.security.DataSealerException;
import org.geant.idpextension.oidc.profile.impl.AbstractOIDCRequestAction;
import org.geant.idpextension.oidc.storage.RevocationCache;
import org.geant.idpextension.oidc.storage.RevocationCacheContexts;
import org.geant.idpextension.oidc.token.support.AccessTokenClaimsSet;
import org.geant.idpextension.oidc.token.support.RefreshTokenClaimsSet;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RevokeToken
extends AbstractOIDCRequestAction<TokenRevocationRequest> {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(RevokeToken.class);
    @Nonnull
    private final DataSealer dataSealer;
    @NonnullAfterInit
    private RevocationCache revocationCache;

    public RevokeToken(@Nonnull @ParameterName(name="sealer") DataSealer sealer) {
        this.dataSealer = (DataSealer)Constraint.isNotNull((Object)sealer, (String)"DataSealer cannot be null");
    }

    public void setRevocationCache(@Nonnull RevocationCache cache) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.revocationCache = (RevocationCache)Constraint.isNotNull((Object)cache, (String)"RevocationCache cannot be null");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        Constraint.isNotNull((Object)this.revocationCache, (String)"RevocationCache cannot be null");
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        AccessTokenClaimsSet tokenClaimsSet = null;
        this.log.debug("{} token to revoke {}", (Object)this.getLogPrefix(), (Object)((TokenRevocationRequest)this.getRequest()).getToken().getValue());
        try {
            tokenClaimsSet = AccessTokenClaimsSet.parse((String)((TokenRevocationRequest)this.getRequest()).getToken().getValue(), (DataSealer)this.dataSealer);
            this.log.debug("{} access token unwrapped {}", (Object)this.getLogPrefix(), (Object)tokenClaimsSet.serialize());
        }
        catch (ParseException | DataSealerException e) {
            this.log.debug("{} token to revoke is not valid access token", (Object)this.getLogPrefix(), (Object)e);
        }
        if (tokenClaimsSet == null) {
            try {
                tokenClaimsSet = RefreshTokenClaimsSet.parse((String)((TokenRevocationRequest)this.getRequest()).getToken().getValue(), (DataSealer)this.dataSealer);
                this.log.debug("{} refresh token unwrapped {}", (Object)this.getLogPrefix(), (Object)tokenClaimsSet.serialize());
            }
            catch (ParseException | DataSealerException e) {
                this.log.debug("{} token to revoke is not valid refresh token", (Object)this.getLogPrefix());
            }
        }
        if (tokenClaimsSet == null) {
            this.log.debug("{} unable to decode token to revoke, nothing to do", (Object)this.getLogPrefix());
            return;
        }
        if (this.revocationCache.revoke(RevocationCacheContexts.AUTHORIZATION_CODE, tokenClaimsSet.getID())) {
            this.log.debug("{} revoked all tokens based on authorize code {}", (Object)this.getLogPrefix(), (Object)tokenClaimsSet.getID());
        } else {
            this.log.warn("{} failed to revoke tokens based on authorize code {}", (Object)this.getLogPrefix(), (Object)tokenClaimsSet.getID());
        }
    }
}

