/*
 * Decompiled with CFR 0.152.
 */
package org.geant.idpextension.oidc.attribute.transcoding.impl;

import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minidev.json.JSONArray;
import net.shibboleth.idp.attribute.AttributeDecodingException;
import net.shibboleth.idp.attribute.AttributeEncodingException;
import net.shibboleth.idp.attribute.ByteAttributeValue;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.IdPAttributeValue;
import net.shibboleth.idp.attribute.transcoding.TranscodingRule;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.codec.Base64Support;
import net.shibboleth.utilities.java.support.codec.EncodingException;
import org.geant.idpextension.oidc.attribute.transcoding.AbstractOIDCAttributeTranscoder;
import org.opensaml.profile.context.ProfileRequestContext;

public class OIDCByteAttributeTranscoder
extends AbstractOIDCAttributeTranscoder {
    @Nullable
    protected Object encodeValues(@Nullable ProfileRequestContext profileRequestContext, @Nonnull IdPAttribute attribute, @Nonnull TranscodingRule rule) throws AttributeEncodingException {
        Boolean asInteger = (Boolean)rule.getOrDefault("oidc.asInteger", Boolean.class, (Object)false);
        Boolean asArray = (Boolean)rule.getOrDefault("oidc.asArray", Boolean.class, (Object)false);
        String delimiter = (String)rule.getOrDefault("oidc.stringDelimiter", String.class, (Object)"");
        Object attributeString = "";
        JSONArray array = new JSONArray();
        for (IdPAttributeValue value : attribute.getValues()) {
            if (!(value instanceof ByteAttributeValue) || ((ByteAttributeValue)value).getValue() == null) continue;
            if (asInteger.booleanValue()) {
                JSONArray innerArray = new JSONArray();
                for (byte byteValue : ((ByteAttributeValue)value).getValue()) {
                    innerArray.add((Object)byteValue);
                }
                array.add((Object)innerArray);
                continue;
            }
            if (((String)attributeString).length() > 0) {
                attributeString = (String)attributeString + delimiter;
            }
            try {
                attributeString = (String)attributeString + Base64Support.encode((byte[])((ByteAttributeValue)value).getValue(), (boolean)false);
            }
            catch (EncodingException e) {
                throw new AttributeEncodingException("Attribtue value could not be base64 encoded", (Exception)((Object)e));
            }
            if (!asArray.booleanValue()) continue;
            array.add((Object)((String)attributeString).toString());
            attributeString = "";
        }
        if (asArray.booleanValue() || asInteger.booleanValue()) {
            return array.size() == 0 ? null : array;
        }
        return ((String)attributeString).toString().isEmpty() ? null : ((String)attributeString).toString();
    }

    @Nonnull
    @NonnullElements
    protected List<IdPAttributeValue> decodeValues(@Nullable ProfileRequestContext profileRequestContext, @Nonnull Object input, @Nonnull TranscodingRule rule) throws AttributeDecodingException {
        return Collections.emptyList();
    }
}

