/*
 * Decompiled with CFR 0.152.
 */
package org.geant.idpextension.oidc.attribute.transcoding.impl;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minidev.json.JSONArray;
import net.shibboleth.idp.attribute.AttributeDecodingException;
import net.shibboleth.idp.attribute.AttributeEncodingException;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.IdPAttributeValue;
import net.shibboleth.idp.attribute.ScopedStringAttributeValue;
import net.shibboleth.idp.attribute.transcoding.TranscodingRule;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import org.geant.idpextension.oidc.attribute.transcoding.AbstractOIDCAttributeTranscoder;
import org.opensaml.profile.context.ProfileRequestContext;

public class OIDCScopedStringAttributeTranscoder
extends AbstractOIDCAttributeTranscoder {
    @Nonnull
    @NotEmpty
    public static final String PROP_SCOPE_DELIMITER = "oidc.scopeDelimiter";

    @Nullable
    protected Object encodeValues(@Nullable ProfileRequestContext profileRequestContext, @Nonnull IdPAttribute attribute, @Nonnull TranscodingRule rule) throws AttributeEncodingException {
        if (attribute.getValues().isEmpty()) {
            return null;
        }
        String scopeDelimiter = (String)rule.getOrDefault(PROP_SCOPE_DELIMITER, String.class, (Object)"@");
        List values = attribute.getValues().stream().filter(ScopedStringAttributeValue.class::isInstance).map(ScopedStringAttributeValue.class::cast).map(v -> v.getValue() + scopeDelimiter + v.getScope()).collect(Collectors.toUnmodifiableList());
        if (((Boolean)rule.getOrDefault("oidc.asArray", Boolean.class, (Object)false)).booleanValue()) {
            JSONArray array = new JSONArray();
            array.addAll(values);
            return array;
        }
        String delimiter = (String)rule.getOrDefault("oidc.stringDelimiter", String.class, (Object)" ");
        boolean stringEmpty = true;
        StringBuilder attributeString = new StringBuilder();
        for (String value : values) {
            if (!stringEmpty) {
                attributeString.append(delimiter);
            } else {
                stringEmpty = false;
            }
            attributeString.append(value);
        }
        return attributeString.length() != 0 ? attributeString.toString() : null;
    }

    @Nonnull
    @NonnullElements
    protected List<IdPAttributeValue> decodeValues(@Nullable ProfileRequestContext profileRequestContext, @Nonnull Object input, @Nonnull TranscodingRule rule) throws AttributeDecodingException {
        return Collections.emptyList();
    }
}

