/*
 * Decompiled with CFR 0.152.
 */
package org.geant.idpextension.oidc.attribute.transcoding.impl;

import com.google.common.base.Predicates;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minidev.json.JSONArray;
import net.minidev.json.parser.JSONParser;
import net.minidev.json.parser.ParseException;
import net.shibboleth.idp.attribute.AttributeDecodingException;
import net.shibboleth.idp.attribute.AttributeEncodingException;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.IdPAttributeValue;
import net.shibboleth.idp.attribute.StringAttributeValue;
import net.shibboleth.idp.attribute.transcoding.TranscodingRule;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.annotation.constraint.NotLive;
import net.shibboleth.utilities.java.support.annotation.constraint.Unmodifiable;
import org.geant.idpextension.oidc.attribute.transcoding.AbstractOIDCAttributeTranscoder;
import org.opensaml.core.xml.schema.XSBooleanValue;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OIDCStringAttributeTranscoder
extends AbstractOIDCAttributeTranscoder {
    @Nonnull
    @NotEmpty
    public static final String PROP_ASOBJECT = "oidc.asObject";
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(OIDCStringAttributeTranscoder.class);

    @Nullable
    protected Object encodeValues(@Nullable ProfileRequestContext profileRequestContext, @Nonnull IdPAttribute attribute, @Nonnull TranscodingRule rule) throws AttributeEncodingException {
        if (attribute.getValues().isEmpty()) {
            return null;
        }
        List<?> values = this.transformValues(rule, attribute.getValues().stream().filter(StringAttributeValue.class::isInstance).map(StringAttributeValue.class::cast).map(StringAttributeValue::getValue));
        if (((Boolean)rule.getOrDefault(PROP_ASOBJECT, Boolean.class, (Object)false)).booleanValue()) {
            if (values.size() == 1) {
                Object value = values.get(0);
                if (!(value instanceof String)) {
                    throw new AttributeEncodingException("Value for IdPAttribute '" + attribute.getId() + "' is defined to be parsed as JSON, but is not String-typed");
                }
                return this.toJSONObject((String)value);
            }
            JSONArray array = new JSONArray();
            for (Object value : values) {
                if (!(value instanceof String)) {
                    this.log.warn("Value for IdPAttribute '{}' is defined to be parsed as JSON, but is not String-typed", (Object)attribute.getId());
                    continue;
                }
                try {
                    array.add(this.toJSONObject((String)value));
                }
                catch (AttributeEncodingException e) {
                    this.log.warn("IdPAttribute '{}'", (Object)attribute.getId(), (Object)e);
                }
            }
            return array;
        }
        if (((Boolean)rule.getOrDefault("oidc.asArray", Boolean.class, (Object)false)).booleanValue()) {
            JSONArray array = new JSONArray();
            array.addAll(values);
            return array;
        }
        String delimiter = (String)rule.getOrDefault("oidc.stringDelimiter", String.class, (Object)" ");
        boolean stringEmpty = true;
        StringBuilder attributeString = new StringBuilder();
        for (Object value : values) {
            if (value instanceof Integer || value instanceof Boolean) {
                this.log.warn("Values converted to Integer/Boolean but non-Array encoding, ignoring all but first value");
                return value;
            }
            if (value instanceof String) {
                if (!stringEmpty) {
                    attributeString.append(delimiter);
                } else {
                    stringEmpty = false;
                }
                attributeString.append(value);
                continue;
            }
            throw new AttributeEncodingException("Unrecognized value type: " + value.getClass().getName());
        }
        return attributeString.length() != 0 ? attributeString.toString() : null;
    }

    @Nonnull
    @NonnullElements
    protected List<IdPAttributeValue> decodeValues(@Nullable ProfileRequestContext profileRequestContext, @Nonnull Object input, @Nonnull TranscodingRule rule) throws AttributeDecodingException {
        return Collections.emptyList();
    }

    @Nonnull
    private Object toJSONObject(@Nonnull @NotEmpty String value) throws AttributeEncodingException {
        try {
            return new JSONParser(-1).parse(value);
        }
        catch (ParseException e) {
            this.log.trace("Unable to parse string '{}' into JSONObject", (Object)value, (Object)e);
            throw new AttributeEncodingException("Unable to parse string into JSONObject", (Exception)((Object)e));
        }
    }

    @Nonnull
    @NonnullElements
    @NotLive
    @Unmodifiable
    private List<?> transformValues(@Nonnull TranscodingRule rule, @Nonnull @NonnullElements Stream<String> attributeValues) {
        if (((Boolean)rule.getOrDefault("oidc.asInteger", Boolean.class, (Object)false)).booleanValue()) {
            this.log.debug("String values interpreted as integer by rule");
            return attributeValues.map(v -> {
                try {
                    return Integer.parseInt(v);
                }
                catch (NumberFormatException e) {
                    this.log.debug("Value '{}' not a parseable integer", v);
                    return null;
                }
            }).filter((Predicate<Integer>)Predicates.notNull()).collect(Collectors.toUnmodifiableList());
        }
        if (((Boolean)rule.getOrDefault("oidc.asBoolean", Boolean.class, (Object)false)).booleanValue()) {
            this.log.debug("String values interpreted as Boolean by rule");
            return attributeValues.map(v -> XSBooleanValue.valueOf((String)v).getValue()).collect(Collectors.toUnmodifiableList());
        }
        return attributeValues.collect(Collectors.toUnmodifiableList());
    }
}

