/*
 * Decompiled with CFR 0.152.
 */
package org.geant.idpextension.oidc.audit.impl;

import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.geant.idpextension.oidc.messaging.context.OIDCAuthenticationResponseContext;
import org.geant.idpextension.oidc.profile.context.navigate.OIDCAuthenticationResponseContextLookupFunction;
import org.opensaml.profile.context.ProfileRequestContext;

public class AuthenticationContextReferenceAuditExtractor
implements Function<ProfileRequestContext, String> {
    @Nonnull
    private final Function<ProfileRequestContext, OIDCAuthenticationResponseContext> ctxLookupStrategy;

    public AuthenticationContextReferenceAuditExtractor() {
        this((Function<ProfileRequestContext, OIDCAuthenticationResponseContext>)new OIDCAuthenticationResponseContextLookupFunction());
    }

    public AuthenticationContextReferenceAuditExtractor(@Nonnull Function<ProfileRequestContext, OIDCAuthenticationResponseContext> strategy) {
        this.ctxLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"OIDC authentication response context lookup strategy cannot be null");
    }

    @Override
    @Nullable
    public String apply(@Nullable ProfileRequestContext input) {
        OIDCAuthenticationResponseContext context = this.ctxLookupStrategy.apply(input);
        if (context != null && context.getAcr() != null) {
            return context.getAcr().getValue();
        }
        return null;
    }
}

