/*
 * Decompiled with CFR 0.152.
 */
package org.geant.idpextension.oidc.audit.impl;

import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.geant.idpextension.oidc.messaging.context.OIDCClientRegistrationResponseContext;
import org.geant.idpextension.oidc.profile.context.navigate.OIDCRegistrationResponseContextLookupFunction;
import org.opensaml.profile.context.ProfileRequestContext;

public class ClientIdRegistrationAuditExtractor
implements Function<ProfileRequestContext, String> {
    @Nonnull
    private final Function<ProfileRequestContext, OIDCClientRegistrationResponseContext> ctxLookupStrategy;

    public ClientIdRegistrationAuditExtractor() {
        this((Function<ProfileRequestContext, OIDCClientRegistrationResponseContext>)new OIDCRegistrationResponseContextLookupFunction());
    }

    public ClientIdRegistrationAuditExtractor(Function<ProfileRequestContext, OIDCClientRegistrationResponseContext> strategy) {
        this.ctxLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"OIDCClientRegistrationResponseContext lookup strategy cannot be null");
    }

    @Override
    @Nullable
    public String apply(@Nullable ProfileRequestContext input) {
        OIDCClientRegistrationResponseContext context = this.ctxLookupStrategy.apply(input);
        if (context != null) {
            return context.getClientId();
        }
        return null;
    }
}

