/*
 * Decompiled with CFR 0.152.
 */
package org.geant.idpextension.oidc.config;

import com.nimbusds.oauth2.sdk.auth.ClientAuthenticationMethod;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.profile.config.AbstractConditionalProfileConfiguration;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.annotation.constraint.NotLive;
import net.shibboleth.utilities.java.support.annotation.constraint.Unmodifiable;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.logic.FunctionSupport;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.geant.idpextension.oidc.profile.config.OIDCProfileConfiguration;
import org.opensaml.profile.context.ProfileRequestContext;

public abstract class AbstractOIDCClientAuthenticableProfileConfiguration
extends AbstractConditionalProfileConfiguration
implements OIDCProfileConfiguration {
    @Nonnull
    private Function<ProfileRequestContext, Collection<String>> tokenEndpointAuthMethodsLookupStrategy;

    protected AbstractOIDCClientAuthenticableProfileConfiguration(@Nonnull @NotEmpty String profileId) {
        super(profileId);
        this.setTokenEndpointAuthMethods(List.of(ClientAuthenticationMethod.CLIENT_SECRET_BASIC.toString(), ClientAuthenticationMethod.CLIENT_SECRET_POST.toString(), ClientAuthenticationMethod.CLIENT_SECRET_JWT.toString(), ClientAuthenticationMethod.PRIVATE_KEY_JWT.toString()));
    }

    @Nonnull
    @NonnullElements
    @NotLive
    @Unmodifiable
    public List<String> getTokenEndpointAuthMethods(@Nullable ProfileRequestContext profileRequestContext) {
        Collection<String> methods = this.tokenEndpointAuthMethodsLookupStrategy.apply(profileRequestContext);
        if (methods != null) {
            return List.copyOf(methods);
        }
        return Collections.emptyList();
    }

    public void setTokenEndpointAuthMethods(@Nonnull @NonnullElements Collection<String> methods) {
        Constraint.isNotNull(methods, (String)"Collection of methods cannot be null");
        this.tokenEndpointAuthMethodsLookupStrategy = methods != null ? FunctionSupport.constant(List.copyOf(StringSupport.normalizeStringCollection(methods))) : FunctionSupport.constant(null);
    }

    public void setTokenEndpointAuthMethodsLookupStrategy(@Nonnull Function<ProfileRequestContext, Collection<String>> strategy) {
        this.tokenEndpointAuthMethodsLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy cannot be null");
    }
}

