/*
 * Decompiled with CFR 0.152.
 */
package org.geant.idpextension.oidc.config;

import com.google.common.base.Predicates;
import java.security.Principal;
import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.authn.config.AuthenticationProfileConfiguration;
import net.shibboleth.utilities.java.support.annotation.constraint.NonNegative;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.annotation.constraint.NotLive;
import net.shibboleth.utilities.java.support.annotation.constraint.Positive;
import net.shibboleth.utilities.java.support.annotation.constraint.Unmodifiable;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.logic.FunctionSupport;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.geant.idpextension.oidc.authn.principal.AuthenticationContextClassReferencePrincipal;
import org.geant.idpextension.oidc.config.AbstractOIDCFlowAwareProfileConfiguration;
import org.opensaml.profile.context.ProfileRequestContext;

public class OIDCCoreProtocolConfiguration
extends AbstractOIDCFlowAwareProfileConfiguration
implements AuthenticationProfileConfiguration {
    @Nonnull
    @NotEmpty
    public static final String PROTOCOL_URI = "http://openid.net/specs/openid-connect-core-1_0.html";
    @Nonnull
    @NotEmpty
    public static final String PROFILE_ID = "http://csc.fi/ns/profiles/oidc/sso/browser";
    @Nonnull
    private Predicate<ProfileRequestContext> resolveAttributesPredicate;
    @Nonnull
    private Predicate<ProfileRequestContext> forceAuthnPredicate = Predicates.alwaysFalse();
    @Nonnull
    private Predicate<ProfileRequestContext> acrRequestAlwaysEssentialPredicate;
    @Nonnull
    private Predicate<ProfileRequestContext> forcePKCEPredicate;
    @Nonnull
    private Predicate<ProfileRequestContext> allowPKCEPlainPredicate;
    @Nonnull
    private Function<ProfileRequestContext, Integer> proxyCountLookupStrategy;
    @Nonnull
    private Function<ProfileRequestContext, Collection<AuthenticationContextClassReferencePrincipal>> defaultAuthenticationContextsLookupStrategy;
    @Nonnull
    private Function<ProfileRequestContext, Set<String>> authenticationFlowsLookupStrategy;
    @Nonnull
    private Function<ProfileRequestContext, Collection<String>> postAuthenticationFlowsLookupStrategy;
    @Nonnull
    private Function<ProfileRequestContext, Duration> idTokenLifetimeLookupStrategy;
    @Nonnull
    private Function<ProfileRequestContext, Duration> authorizeCodeLifetimeLookupStrategy;
    @Nonnull
    private Function<ProfileRequestContext, Duration> accessTokenLifetimeLookupStrategy;
    @Nonnull
    private Function<ProfileRequestContext, Duration> refreshTokenLifetimeLookupStrategy;
    @Nonnull
    private Function<ProfileRequestContext, Set<String>> assertionAudiencesLookupStrategy;

    public OIDCCoreProtocolConfiguration() {
        this(PROFILE_ID);
    }

    public OIDCCoreProtocolConfiguration(@Nonnull @NotEmpty String profileId) {
        super(profileId);
        this.resolveAttributesPredicate = Predicates.alwaysTrue();
        this.proxyCountLookupStrategy = FunctionSupport.constant(null);
        this.assertionAudiencesLookupStrategy = FunctionSupport.constant(null);
        this.idTokenLifetimeLookupStrategy = FunctionSupport.constant((Object)Duration.ofHours(1L));
        this.authorizeCodeLifetimeLookupStrategy = FunctionSupport.constant((Object)Duration.ofMinutes(5L));
        this.accessTokenLifetimeLookupStrategy = FunctionSupport.constant((Object)Duration.ofMinutes(10L));
        this.refreshTokenLifetimeLookupStrategy = FunctionSupport.constant((Object)Duration.ofHours(2L));
        this.acrRequestAlwaysEssentialPredicate = Predicates.alwaysFalse();
        this.forcePKCEPredicate = Predicates.alwaysFalse();
        this.allowPKCEPlainPredicate = Predicates.alwaysFalse();
        this.defaultAuthenticationContextsLookupStrategy = FunctionSupport.constant(null);
        this.authenticationFlowsLookupStrategy = FunctionSupport.constant(null);
        this.postAuthenticationFlowsLookupStrategy = FunctionSupport.constant(null);
    }

    public boolean isResolveAttributes(@Nullable ProfileRequestContext profileRequestContext) {
        return this.resolveAttributesPredicate.test(profileRequestContext);
    }

    public void setResolveAttributes(boolean flag) {
        this.resolveAttributesPredicate = flag ? Predicates.alwaysTrue() : Predicates.alwaysFalse();
    }

    public void setResolveAttributesPredicate(@Nonnull Predicate<ProfileRequestContext> condition) {
        this.resolveAttributesPredicate = (Predicate)Constraint.isNotNull(condition, (String)"Resolve attributes predicate cannot be null");
    }

    public boolean isForceAuthn(@Nullable ProfileRequestContext profileRequestContext) {
        return this.forceAuthnPredicate.test(profileRequestContext);
    }

    public void setForceAuthn(boolean flag) {
        this.forceAuthnPredicate = flag ? Predicates.alwaysTrue() : Predicates.alwaysFalse();
    }

    public void setForceAuthnPredicate(@Nonnull Predicate<ProfileRequestContext> condition) {
        this.forceAuthnPredicate = (Predicate)Constraint.isNotNull(condition, (String)"Forced authentication predicate cannot be null");
    }

    @Nullable
    public Integer getProxyCount(@Nullable ProfileRequestContext profileRequestContext) {
        Integer count = this.proxyCountLookupStrategy.apply(profileRequestContext);
        if (count != null) {
            Constraint.isGreaterThanOrEqual((int)0, (int)count, (String)"Proxy count must be greater than or equal to 0");
        }
        return count;
    }

    public void setProxyCount(@Nullable @NonNegative Integer count) {
        if (count != null) {
            Constraint.isGreaterThanOrEqual((int)0, (int)count, (String)"Proxy count must be greater than or equal to 0");
        }
        this.proxyCountLookupStrategy = FunctionSupport.constant((Object)count);
    }

    public void setProxyCountLookupStrategy(@Nonnull Function<ProfileRequestContext, Integer> strategy) {
        this.proxyCountLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy cannot be null");
    }

    @Nonnull
    @NonnullElements
    @NotLive
    @Unmodifiable
    public Set<String> getAuthenticationFlows(@Nullable ProfileRequestContext profileRequestContext) {
        Set<String> flows = this.authenticationFlowsLookupStrategy.apply(profileRequestContext);
        if (flows != null) {
            return Set.copyOf(flows);
        }
        return Collections.emptySet();
    }

    public void setAuthenticationFlows(@Nullable @NonnullElements Collection<String> flows) {
        this.authenticationFlowsLookupStrategy = flows != null ? FunctionSupport.constant(Set.copyOf(StringSupport.normalizeStringCollection(flows))) : FunctionSupport.constant(null);
    }

    public void setAuthenticationFlowsLookupStrategy(@Nonnull Function<ProfileRequestContext, Set<String>> strategy) {
        this.authenticationFlowsLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy cannot be null");
    }

    @Nonnull
    @NonnullElements
    @NotLive
    @Unmodifiable
    public List<String> getPostAuthenticationFlows(@Nullable ProfileRequestContext profileRequestContext) {
        Collection<String> flows = this.postAuthenticationFlowsLookupStrategy.apply(profileRequestContext);
        if (flows != null) {
            return List.copyOf(flows);
        }
        return Collections.emptyList();
    }

    public void setPostAuthenticationFlows(@Nullable @NonnullElements Collection<String> flows) {
        this.postAuthenticationFlowsLookupStrategy = flows != null ? FunctionSupport.constant(List.copyOf(StringSupport.normalizeStringCollection(flows))) : FunctionSupport.constant(null);
    }

    public void setPostAuthenticationFlowsLookupStrategy(@Nonnull Function<ProfileRequestContext, Collection<String>> strategy) {
        this.postAuthenticationFlowsLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy cannot be null");
    }

    @Nonnull
    @NonnullElements
    @NotLive
    @Unmodifiable
    public List<Principal> getDefaultAuthenticationMethods(@Nullable ProfileRequestContext profileRequestContext) {
        Collection<AuthenticationContextClassReferencePrincipal> methods = this.defaultAuthenticationContextsLookupStrategy.apply(profileRequestContext);
        if (methods != null) {
            return List.copyOf(methods);
        }
        return Collections.emptyList();
    }

    public void setDefaultAuthenticationMethods(@Nullable @NonnullElements Collection<AuthenticationContextClassReferencePrincipal> contexts) {
        this.defaultAuthenticationContextsLookupStrategy = contexts != null ? FunctionSupport.constant(List.copyOf(contexts)) : FunctionSupport.constant(null);
    }

    public void setDefaultAuthenticationMethodsLookupStrategy(@Nonnull Function<ProfileRequestContext, Collection<AuthenticationContextClassReferencePrincipal>> strategy) {
        this.defaultAuthenticationContextsLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy cannot be null");
    }

    @Nonnull
    @Positive
    public Duration getIDTokenLifetime(@Nullable ProfileRequestContext profileRequestContext) {
        Duration lifetime = this.idTokenLifetimeLookupStrategy.apply(profileRequestContext);
        Constraint.isTrue((lifetime != null && !lifetime.isZero() && !lifetime.isNegative() ? 1 : 0) != 0, (String)"ID token lifetime must be greater than 0");
        return lifetime;
    }

    public void setIDTokenLifetime(@Nonnull @Positive Duration lifetime) {
        Constraint.isTrue((lifetime != null && !lifetime.isZero() && !lifetime.isNegative() ? 1 : 0) != 0, (String)"ID token lifetime must be greater than 0");
        this.idTokenLifetimeLookupStrategy = FunctionSupport.constant((Object)lifetime);
    }

    public void setIDTokenLifetimeLookupStrategy(@Nonnull Function<ProfileRequestContext, Duration> strategy) {
        this.idTokenLifetimeLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy cannot be null");
    }

    @Nonnull
    @Positive
    public Duration getAccessTokenLifetime(@Nullable ProfileRequestContext profileRequestContext) {
        Duration lifetime = this.accessTokenLifetimeLookupStrategy.apply(profileRequestContext);
        Constraint.isTrue((lifetime != null && !lifetime.isZero() && !lifetime.isNegative() ? 1 : 0) != 0, (String)"Access token lifetime must be greater than 0");
        return lifetime;
    }

    public void setAccessTokenLifetime(@Nonnull @Positive Duration lifetime) {
        Constraint.isTrue((lifetime != null && !lifetime.isZero() && !lifetime.isNegative() ? 1 : 0) != 0, (String)"Access token lifetime must be greater than 0");
        this.accessTokenLifetimeLookupStrategy = FunctionSupport.constant((Object)lifetime);
    }

    public void setAccessTokenLifetimeLookupStrategy(@Nullable Function<ProfileRequestContext, Duration> strategy) {
        this.accessTokenLifetimeLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy cannot be null");
    }

    @Nonnull
    @Positive
    public Duration getAuthorizeCodeLifetime(@Nullable ProfileRequestContext profileRequestContext) {
        Duration lifetime = this.authorizeCodeLifetimeLookupStrategy.apply(profileRequestContext);
        Constraint.isTrue((lifetime != null && !lifetime.isZero() && !lifetime.isNegative() ? 1 : 0) != 0, (String)"Authorization code lifetime must be greater than 0");
        return lifetime;
    }

    public void setAuthorizeCodeLifetime(@Nonnull @Positive Duration lifetime) {
        Constraint.isTrue((lifetime != null && !lifetime.isZero() && !lifetime.isNegative() ? 1 : 0) != 0, (String)"Authorization code lifetime must be greater than 0");
        this.authorizeCodeLifetimeLookupStrategy = FunctionSupport.constant((Object)lifetime);
    }

    public void setAuthorizeCodeLifetimeLookupStrategy(@Nonnull Function<ProfileRequestContext, Duration> strategy) {
        this.authorizeCodeLifetimeLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy cannot be null");
    }

    @Nonnull
    @Positive
    public Duration getRefreshTokenLifetime(@Nullable ProfileRequestContext profileRequestContext) {
        Duration lifetime = this.refreshTokenLifetimeLookupStrategy.apply(profileRequestContext);
        Constraint.isTrue((lifetime != null && !lifetime.isZero() && !lifetime.isNegative() ? 1 : 0) != 0, (String)"Refresh token lifetime must be greater than 0");
        return lifetime;
    }

    public void setRefreshTokenLifetime(@Nonnull @Positive Duration lifetime) {
        Constraint.isTrue((lifetime != null && !lifetime.isZero() && !lifetime.isNegative() ? 1 : 0) != 0, (String)"Refresh token lifetime must be greater than 0");
        this.refreshTokenLifetimeLookupStrategy = FunctionSupport.constant((Object)lifetime);
    }

    public void setRefreshTokenLifetimeLookupStrategy(@Nullable Function<ProfileRequestContext, Duration> strategy) {
        this.refreshTokenLifetimeLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy cannot be null");
    }

    @Nonnull
    @NonnullElements
    @NotLive
    public Set<String> getAdditionalAudiencesForIdToken(@Nullable ProfileRequestContext profileRequestContext) {
        Set<String> audiences = this.assertionAudiencesLookupStrategy.apply(profileRequestContext);
        if (audiences != null) {
            return Set.copyOf(audiences);
        }
        return Collections.emptySet();
    }

    public void setAdditionalAudiencesForIdToken(@Nullable @NonnullElements Collection<String> audiences) {
        this.assertionAudiencesLookupStrategy = audiences == null || audiences.isEmpty() ? FunctionSupport.constant(null) : FunctionSupport.constant(Set.copyOf(StringSupport.normalizeStringCollection(audiences)));
    }

    public void setAdditionalAudiencesForIdTokenLookupStrategy(@Nonnull Function<ProfileRequestContext, Set<String>> strategy) {
        this.assertionAudiencesLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy cannot be null");
    }

    public boolean isAcrRequestAlwaysEssential(@Nullable ProfileRequestContext profileRequestContext) {
        return this.acrRequestAlwaysEssentialPredicate.test(profileRequestContext);
    }

    public void setAcrRequestAlwaysEssential(boolean flag) {
        this.acrRequestAlwaysEssentialPredicate = flag ? Predicates.alwaysTrue() : Predicates.alwaysFalse();
    }

    public void setAcrRequestAlwaysEssentialPredicate(@Nonnull Predicate<ProfileRequestContext> condition) {
        this.acrRequestAlwaysEssentialPredicate = (Predicate)Constraint.isNotNull(condition, (String)"Condition cannot be null");
    }

    public boolean isForcePKCE(@Nullable ProfileRequestContext profileRequestContext) {
        return this.forcePKCEPredicate.test(profileRequestContext);
    }

    public void setForcePKCE(boolean flag) {
        this.forcePKCEPredicate = flag ? Predicates.alwaysTrue() : Predicates.alwaysFalse();
    }

    public void setForcePKCEPredicate(@Nonnull Predicate<ProfileRequestContext> condition) {
        this.forcePKCEPredicate = (Predicate)Constraint.isNotNull(condition, (String)"Condition cannot be null");
    }

    public boolean isAllowPKCEPlain(@Nullable ProfileRequestContext profileRequestContext) {
        return this.allowPKCEPlainPredicate.test(profileRequestContext);
    }

    public void setAllowPKCEPlain(boolean flag) {
        this.allowPKCEPlainPredicate = flag ? Predicates.alwaysTrue() : Predicates.alwaysFalse();
    }

    public void setAllowPKCEPlain(@Nonnull Predicate<ProfileRequestContext> condition) {
        this.allowPKCEPlainPredicate = (Predicate)Constraint.isNotNull(condition, (String)"Condition cannot be null");
    }
}

