/*
 * Decompiled with CFR 0.152.
 */
package org.geant.idpextension.oidc.config;

import java.time.Duration;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.utilities.java.support.annotation.constraint.NonNegative;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.logic.FunctionSupport;
import org.geant.idpextension.oidc.config.AbstractOIDCFlowAwareProfileConfiguration;
import org.opensaml.profile.context.ProfileRequestContext;

public class OIDCDynamicRegistrationConfiguration
extends AbstractOIDCFlowAwareProfileConfiguration {
    public static final String PROTOCOL_URI = "https://openid.net/specs/openid-connect-registration-1_0.html";
    public static final String PROFILE_ID = "http://csc.fi/ns/profiles/oidc/registration";
    @Nonnull
    private Function<ProfileRequestContext, Duration> registrationValidityPeriodLookupStrategy;
    @Nullable
    private Function<ProfileRequestContext, Duration> secretExpirationPeriodLookupStrategy;

    public OIDCDynamicRegistrationConfiguration() {
        this(PROFILE_ID);
    }

    public OIDCDynamicRegistrationConfiguration(@Nonnull @NotEmpty String profileId) {
        super(profileId);
        this.setRegistrationValidityPeriod(Duration.ZERO);
        this.setSecretExpirationPeriod(Duration.ZERO);
    }

    @Nullable
    @NonNegative
    public Duration getRegistrationValidityPeriod(@Nullable ProfileRequestContext profileRequestContext) {
        Duration period = this.registrationValidityPeriodLookupStrategy.apply(profileRequestContext);
        Constraint.isFalse((period != null && period.isNegative() ? 1 : 0) != 0, (String)"Validity period cannot be negative");
        return period;
    }

    public void setRegistrationValidityPeriod(@Nullable @NonNegative Duration period) {
        Constraint.isFalse((period != null && period.isNegative() ? 1 : 0) != 0, (String)"Validity period cannot be negative");
        this.registrationValidityPeriodLookupStrategy = FunctionSupport.constant((Object)period);
    }

    public void setRegistrationValidityPeriodLookupStrategy(@Nonnull Function<ProfileRequestContext, Duration> strategy) {
        this.registrationValidityPeriodLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy cannot be null");
    }

    @Nullable
    @NonNegative
    public Duration getSecretExpirationPeriod(@Nullable ProfileRequestContext profileRequestContext) {
        Duration period = this.secretExpirationPeriodLookupStrategy.apply(profileRequestContext);
        Constraint.isFalse((period != null && period.isNegative() ? 1 : 0) != 0, (String)"Validity period cannot be negative");
        return period;
    }

    public void setSecretExpirationPeriod(@Nullable @NonNegative Duration period) {
        Constraint.isFalse((period != null && period.isNegative() ? 1 : 0) != 0, (String)"Validity period cannot be negative");
        this.secretExpirationPeriodLookupStrategy = FunctionSupport.constant((Object)period);
    }

    public void setSecretExpirationPeriodLookupStrategy(@Nonnull Function<ProfileRequestContext, Duration> strategy) {
        this.secretExpirationPeriodLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy cannot be null");
    }
}

