/*
 * Decompiled with CFR 0.152.
 */
package org.geant.idpextension.oidc.decoding.impl;

import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.http.HTTPRequest;
import com.nimbusds.oauth2.sdk.http.ServletUtils;
import com.nimbusds.openid.connect.sdk.rp.OIDCClientRegistrationRequest;
import java.io.IOException;
import javax.annotation.Nonnull;
import javax.servlet.http.HttpServletRequest;
import net.minidev.json.JSONObject;
import org.geant.idpextension.oidc.decoding.impl.RequestUtil;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.decoder.MessageDecodingException;
import org.opensaml.messaging.decoder.servlet.AbstractHttpServletRequestMessageDecoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OIDCClientRegistrationRequestDecoder
extends AbstractHttpServletRequestMessageDecoder {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(OIDCClientRegistrationRequestDecoder.class);

    protected void doDecode() throws MessageDecodingException {
        MessageContext messageContext = new MessageContext();
        try {
            HTTPRequest httpRequest = ServletUtils.createHTTPRequest((HttpServletRequest)this.getHttpServletRequest());
            this.log.debug("Inbound request {}", (Object)RequestUtil.toString(httpRequest));
            JSONObject requestJson = httpRequest.getQueryAsJSONObject();
            if (requestJson.containsKey((Object)"scope")) {
                this.log.debug("Removed 'scope'");
                requestJson.remove((Object)"scope");
                httpRequest.setQuery(requestJson.toJSONString());
            }
            this.log.trace("JSON object: {}", (Object)httpRequest.getQueryAsJSONObject().toJSONString());
            OIDCClientRegistrationRequest request = OIDCClientRegistrationRequest.parse((HTTPRequest)httpRequest);
            messageContext.setMessage((Object)request);
            this.log.debug("Decoded OIDC client registration request {}", (Object)request.toHTTPRequest());
        }
        catch (IOException e) {
            this.log.error("Could not create HTTP request from the request", (Throwable)e);
            throw new MessageDecodingException((Exception)e);
        }
        catch (ParseException e) {
            this.log.error("Unable to decode oidc request: {}", (Object)e.getMessage());
            throw new MessageDecodingException((Exception)((Object)e));
        }
        this.setMessageContext(messageContext);
    }
}

