/*
 * Decompiled with CFR 0.152.
 */
package org.geant.idpextension.oidc.decoding.impl;

import javax.annotation.Nonnull;
import javax.servlet.http.HttpServletRequest;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.geant.idpextension.oidc.messaging.impl.OIDCWebFingerRequestImpl;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.decoder.MessageDecodingException;
import org.opensaml.messaging.decoder.servlet.AbstractHttpServletRequestMessageDecoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OIDCWebFingerRequestDecoder
extends AbstractHttpServletRequestMessageDecoder {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(OIDCWebFingerRequestDecoder.class);

    protected void doDecode() throws MessageDecodingException {
        MessageContext messageContext = new MessageContext();
        HttpServletRequest httpRequest = this.getHttpServletRequest();
        String resource = StringSupport.trimOrNull((String)httpRequest.getParameter("resource"));
        if (resource == null) {
            this.log.error("No resource parameter value found from the request");
            throw new MessageDecodingException("Mandatory value for resource is missing");
        }
        String rel = StringSupport.trim((String)httpRequest.getParameter("rel"));
        if (rel == null) {
            this.log.error("No rel parameter value found from the request");
            throw new MessageDecodingException("Mandatory value for rel is missing");
        }
        OIDCWebFingerRequestImpl request = new OIDCWebFingerRequestImpl(resource, rel);
        this.log.debug("Decoded Web Finger request with resource = {} and rel = {}", (Object)resource, (Object)rel);
        messageContext.setMessage((Object)request);
        this.setMessageContext(messageContext);
    }
}

