/*
 * Decompiled with CFR 0.152.
 */
package org.geant.idpextension.oidc.encoding.impl;

import com.nimbusds.oauth2.sdk.AuthorizationResponse;
import com.nimbusds.oauth2.sdk.Response;
import com.nimbusds.oauth2.sdk.ResponseMode;
import com.nimbusds.oauth2.sdk.http.HTTPResponse;
import com.nimbusds.oauth2.sdk.http.ServletUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletResponse;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.codec.HTMLEncoder;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.DestructableComponent;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.net.HttpServletSupport;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.geant.idpextension.oidc.encoding.impl.ResponseUtil;
import org.opensaml.messaging.encoder.MessageEncodingException;
import org.opensaml.messaging.encoder.servlet.AbstractHttpServletResponseMessageEncoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NimbusResponseEncoder
extends AbstractHttpServletResponseMessageEncoder {
    @Nonnull
    @NotEmpty
    public static final String DEFAULT_TEMPLATE_ID = "/templates/oidc-form-post.vm";
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(NimbusResponseEncoder.class);
    @Nullable
    private VelocityEngine velocityEngine;
    @Nonnull
    @NotEmpty
    private String velocityTemplateId = "/templates/oidc-form-post.vm";

    public void setVelocityTemplateId(String newVelocityTemplateId) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        Constraint.isNotEmpty((String)newVelocityTemplateId, (String)"Velocity template id must not not be null or empty");
        this.velocityTemplateId = newVelocityTemplateId;
    }

    public void setVelocityEngine(VelocityEngine newVelocityEngine) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        this.velocityEngine = newVelocityEngine;
    }

    private boolean impliesFormPost(@Nullable Object response) {
        return response instanceof AuthorizationResponse && ResponseMode.FORM_POST.equals((Object)((AuthorizationResponse)response).getResponseMode());
    }

    private VelocityContext doPostEncode(@Nonnull AuthorizationResponse message) {
        VelocityContext context = new VelocityContext();
        for (Map.Entry entry : message.toParameters().entrySet()) {
            context.put((String)entry.getKey(), ((List)entry.getValue()).get(0));
        }
        context.put("action", (Object)HTMLEncoder.encodeForHTMLAttribute((String)message.getRedirectionURI().toString()));
        return context;
    }

    protected void doEncode() throws MessageEncodingException {
        if (!(this.getMessageContext().getMessage() instanceof Response)) {
            throw new MessageEncodingException("Incorrect message type");
        }
        try {
            HttpServletResponse response = this.getHttpServletResponse();
            if (this.impliesFormPost(this.getMessageContext().getMessage())) {
                if (this.velocityEngine == null) {
                    throw new MessageEncodingException("VelocityEngine must be supplied for form post response mode");
                }
                VelocityContext context = this.doPostEncode((AuthorizationResponse)this.getMessageContext().getMessage());
                HttpServletSupport.addNoCacheHeaders((HttpServletResponse)response);
                HttpServletSupport.setUTF8Encoding((HttpServletResponse)response);
                HttpServletSupport.setContentType((HttpServletResponse)response, (String)"text/html");
                OutputStreamWriter out = new OutputStreamWriter((OutputStream)response.getOutputStream(), "UTF-8");
                this.velocityEngine.mergeTemplate(this.velocityTemplateId, "UTF-8", (Context)context, (Writer)out);
                ((Writer)out).flush();
                ((Writer)out).close();
                StringWriter writer = new StringWriter();
                this.velocityEngine.mergeTemplate(this.velocityTemplateId, "UTF-8", (Context)context, (Writer)writer);
                this.log.debug("Outbound response {}", (Object)ResponseUtil.toString(response, writer.toString()));
                return;
            }
            HTTPResponse resp = ((Response)this.getMessageContext().getMessage()).toHTTPResponse();
            this.log.debug("Outbound response {}", (Object)ResponseUtil.toString(resp));
            ServletUtils.applyHTTPResponse((HTTPResponse)resp, (HttpServletResponse)response);
        }
        catch (IOException e) {
            throw new MessageEncodingException("Problem encoding response", (Exception)e);
        }
    }
}

