/*
 * Decompiled with CFR 0.152.
 */
package org.geant.idpextension.oidc.metadata.impl;

import com.google.common.base.Strings;
import com.nimbusds.oauth2.sdk.id.Identifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.component.AbstractIdentifiableInitializableComponent;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.DestructableComponent;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.resolver.ResolverException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractOIDCEntityResolver<Key extends Identifier, Value>
extends AbstractIdentifiableInitializableComponent {
    private final Logger log = LoggerFactory.getLogger(AbstractOIDCEntityResolver.class);
    private JsonBackingStore jsonBackingStore;
    private boolean failFastInitialization = true;

    public boolean isFailFastInitialization() {
        return this.failFastInitialization;
    }

    public void setFailFastInitialization(boolean failFast) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        this.failFastInitialization = failFast;
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        try {
            this.initOIDCResolver();
        }
        catch (ComponentInitializationException e) {
            if (this.failFastInitialization) {
                this.log.error("OIDC metadata provider failed to properly initialize, fail-fast=true, halting", (Throwable)e);
                throw e;
            }
            this.log.error("OIDC metadata provider failed to properly initialize, fail-fast=false, continuing on in a degraded state", (Throwable)e);
        }
    }

    protected void initOIDCResolver() throws ComponentInitializationException {
        this.jsonBackingStore = this.createNewBackingStore();
    }

    @Nonnull
    @NonnullElements
    protected List<Value> lookupIdentifier(@Nonnull @NotEmpty Key identifier) throws ResolverException {
        if (!this.isInitialized()) {
            throw new ResolverException("Metadata resolver has not been initialized");
        }
        if (identifier == null || Strings.isNullOrEmpty((String)identifier.getValue())) {
            this.log.debug("Identifier was null or empty, skipping search for it");
            return Collections.emptyList();
        }
        List<Value> allInformation = this.lookupIndexedIdentifier(identifier);
        if (allInformation.isEmpty()) {
            this.log.debug("Backing store does not contain any information with the ID: {}", identifier);
            return allInformation;
        }
        return allInformation;
    }

    @Nonnull
    @NonnullElements
    protected List<Value> lookupIndexedIdentifier(@Nonnull @NotEmpty Key identifier) {
        List allInformation = this.getBackingStore().getIndexedInformation().get(identifier);
        if (allInformation != null) {
            return new ArrayList(allInformation);
        }
        return Collections.emptyList();
    }

    protected void preProcessEntityDescriptor(@Nonnull Value entityDescriptor, @Nonnull Key key, @Nonnull JsonBackingStore backingStore) {
        backingStore.getOrderedInformation().add(entityDescriptor);
        this.indexEntityDescriptor(entityDescriptor, key, backingStore);
    }

    protected void removeByIdentifier(@Nonnull Key identifier, @Nonnull JsonBackingStore backingStore) {
        Map indexedDescriptors = backingStore.getIndexedInformation();
        List descriptors = indexedDescriptors.get(identifier);
        if (descriptors != null) {
            backingStore.getOrderedInformation().removeAll(descriptors);
        }
        indexedDescriptors.remove(identifier);
    }

    protected void indexEntityDescriptor(@Nonnull Value entityDescriptor, @Nonnull Key key, @Nonnull JsonBackingStore backingStore) {
        List entities = backingStore.getIndexedInformation().get(key);
        if (entities == null) {
            entities = new ArrayList();
            backingStore.getIndexedInformation().put(key, entities);
        } else if (!entities.isEmpty()) {
            this.log.warn("Detected duplicate object for key: {}", key);
        }
        entities.add(entityDescriptor);
    }

    @Nonnull
    protected JsonBackingStore createNewBackingStore() {
        return new JsonBackingStore();
    }

    @Nonnull
    protected JsonBackingStore getBackingStore() {
        return this.jsonBackingStore;
    }

    protected void setBackingStore(@Nonnull JsonBackingStore newBackingStore) {
        this.jsonBackingStore = (JsonBackingStore)Constraint.isNotNull((Object)newBackingStore, (String)"JsonBackingStore may not be null");
    }

    protected class JsonBackingStore {
        private Map<Key, List<Value>> indexedEntities = new ConcurrentHashMap();
        private List<Value> orderedEntitiess = new ArrayList();

        protected JsonBackingStore() {
        }

        @Nonnull
        public Map<Key, List<Value>> getIndexedInformation() {
            return this.indexedEntities;
        }

        @Nonnull
        public List<Value> getOrderedInformation() {
            return this.orderedEntitiess;
        }
    }
}

