/*
 * Decompiled with CFR 0.152.
 */
package org.geant.idpextension.oidc.metadata.impl;

import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.id.Identifier;
import java.time.Duration;
import java.time.Instant;
import java.time.ZoneId;
import java.util.Arrays;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.utilities.java.support.annotation.constraint.Positive;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.DestructableComponent;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.resolver.ResolverException;
import org.geant.idpextension.oidc.metadata.impl.AbstractOIDCEntityResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractReloadingOIDCEntityResolver<Key extends Identifier, Value>
extends AbstractOIDCEntityResolver<Key, Value> {
    private final Logger log = LoggerFactory.getLogger(AbstractReloadingOIDCEntityResolver.class);
    private Timer taskTimer;
    private boolean createdOwnTaskTimer;
    private RefreshMetadataTask refreshMetadataTask;
    @Nonnull
    @Positive
    private Duration maxRefreshDelay = Duration.ofHours(4L);
    @Nonnull
    @Positive
    private Duration minRefreshDelay = Duration.ofMinutes(5L);
    @Nullable
    private Instant lastUpdate;
    @Nullable
    private Instant lastRefresh;
    @Nullable
    private Instant nextRefresh;

    protected AbstractReloadingOIDCEntityResolver() {
        this(null);
    }

    protected AbstractReloadingOIDCEntityResolver(@Nullable Timer backgroundTaskTimer) {
        if (backgroundTaskTimer == null) {
            this.taskTimer = new Timer(true);
            this.createdOwnTaskTimer = true;
        } else {
            this.taskTimer = backgroundTaskTimer;
        }
    }

    @Override
    protected void initOIDCResolver() throws ComponentInitializationException {
        super.initOIDCResolver();
        try {
            this.refresh();
        }
        catch (ResolverException e) {
            this.log.error("Could not refresh the entity information", (Throwable)e);
            throw new ComponentInitializationException("Could not refresh the entity information", (Exception)((Object)e));
        }
    }

    @Nullable
    public Instant getLastUpdate() {
        return this.lastUpdate;
    }

    @Nullable
    public Instant getLastRefresh() {
        return this.lastRefresh;
    }

    public void setMinRefreshDelay(@Nonnull @Positive Duration delay) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        Constraint.isFalse((delay == null || delay.isNegative() ? 1 : 0) != 0, (String)"Minimum refresh delay must be greater than 0");
        this.minRefreshDelay = delay;
    }

    public void setMaxRefreshDelay(@Nonnull @Positive Duration delay) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        Constraint.isFalse((delay == null || delay.isNegative() ? 1 : 0) != 0, (String)"Maximum refresh delay must be greater than 0");
        this.maxRefreshDelay = delay;
    }

    public synchronized void refresh() throws ResolverException {
        Instant now = Instant.now();
        String mdId = this.getMetadataIdentifier();
        Duration refreshDelay = null;
        this.log.debug("Beginning refresh of metadata from '{}'", (Object)mdId);
        try {
            byte[] mdBytes = this.fetchMetadata();
            if (mdBytes == null) {
                this.log.debug("Metadata from '{}' has not changed since last refresh", (Object)mdId);
            } else {
                this.log.debug("Processing new metadata from '{}'", (Object)mdId);
                List<Value> resolvedInformation = this.parse(mdBytes);
                AbstractOIDCEntityResolver.JsonBackingStore newBackingStore = new AbstractOIDCEntityResolver.JsonBackingStore(this);
                for (Value information : resolvedInformation) {
                    Key id = this.getKey(information);
                    this.log.info("Parsed entity information for {}", id);
                    newBackingStore.getIndexedInformation().put(id, Arrays.asList(information));
                    newBackingStore.getOrderedInformation().add(information);
                }
                this.setBackingStore(newBackingStore);
                this.lastUpdate = now;
            }
            this.scheduleNextRefresh(refreshDelay);
            this.lastRefresh = now;
        }
        catch (Throwable t) {
            try {
                this.log.error("Error occurred while attempting to refresh metadata from '" + mdId + "'", t);
                refreshDelay = this.minRefreshDelay;
                if (t instanceof Exception) {
                    throw new ResolverException((Exception)t);
                }
                throw new ResolverException(String.format("Saw an error of type '%s' with message '%s'", t.getClass().getName(), t.getMessage()));
            }
            catch (Throwable throwable) {
                this.scheduleNextRefresh(refreshDelay);
                this.lastRefresh = now;
                throw throwable;
            }
        }
    }

    protected void scheduleNextRefresh(@Nullable Duration delay) {
        this.refreshMetadataTask = new RefreshMetadataTask();
        Duration refreshDelay = delay;
        if (delay == null || delay.isZero()) {
            refreshDelay = this.maxRefreshDelay;
        }
        this.nextRefresh = Instant.now().plus(refreshDelay);
        long nextRefreshDelay = this.nextRefresh.toEpochMilli() - System.currentTimeMillis();
        this.taskTimer.schedule((TimerTask)this.refreshMetadataTask, nextRefreshDelay);
        this.log.info("Next refresh cycle for metadata provider '{}' will occur on '{}' ('{}' local time)", new Object[]{this.getMetadataIdentifier(), this.nextRefresh, this.nextRefresh.atZone(ZoneId.systemDefault())});
    }

    protected abstract List<Value> parse(byte[] var1) throws ParseException;

    protected abstract Key getKey(Value var1);

    protected abstract String getMetadataIdentifier();

    protected abstract byte[] fetchMetadata() throws ResolverException;

    private class RefreshMetadataTask
    extends TimerTask {
        private RefreshMetadataTask() {
        }

        @Override
        public void run() {
            try {
                if (!AbstractReloadingOIDCEntityResolver.this.isInitialized()) {
                    return;
                }
                AbstractReloadingOIDCEntityResolver.this.refresh();
            }
            catch (ResolverException e) {
                return;
            }
        }
    }
}

