/*
 * Decompiled with CFR 0.152.
 */
package org.geant.idpextension.oidc.metadata.impl;

import com.nimbusds.openid.connect.sdk.rp.OIDCClientInformation;
import java.lang.invoke.CallSite;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.NotLive;
import net.shibboleth.utilities.java.support.annotation.constraint.Unmodifiable;
import net.shibboleth.utilities.java.support.component.AbstractIdentifiableInitializableComponent;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.DestructableComponent;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import net.shibboleth.utilities.java.support.resolver.ResolverException;
import org.geant.idpextension.oidc.metadata.resolver.ClientInformationResolver;
import org.geant.idpextension.oidc.metadata.resolver.RefreshableClientInformationResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChainingClientInformationResolver
extends AbstractIdentifiableInitializableComponent
implements ClientInformationResolver,
RefreshableClientInformationResolver {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(ChainingClientInformationResolver.class);
    @Nonnull
    @NonnullElements
    private List<ClientInformationResolver> resolvers = Collections.emptyList();

    @Nonnull
    @NonnullElements
    @Unmodifiable
    @NotLive
    public List<ClientInformationResolver> getResolvers() {
        return List.copyOf(this.resolvers);
    }

    public void setResolvers(@Nonnull @NonnullElements List<? extends ClientInformationResolver> newResolvers) throws ResolverException {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        this.resolvers = newResolvers == null || newResolvers.isEmpty() ? Collections.emptyList() : List.copyOf(newResolvers);
    }

    @Nullable
    public OIDCClientInformation resolveSingle(@Nullable CriteriaSet criteria) throws ResolverException {
        Iterator<OIDCClientInformation> iterator;
        ComponentSupport.ifNotInitializedThrowUninitializedComponentException((InitializableComponent)this);
        Iterable<OIDCClientInformation> iterable = this.resolve(criteria);
        if (iterable != null && (iterator = iterable.iterator()) != null && iterator.hasNext()) {
            return iterator.next();
        }
        return null;
    }

    @Nonnull
    public Iterable<OIDCClientInformation> resolve(@Nullable CriteriaSet criteria) throws ResolverException {
        ComponentSupport.ifNotInitializedThrowUninitializedComponentException((InitializableComponent)this);
        for (ClientInformationResolver resolver : this.resolvers) {
            try {
                Iterable clientInformations = resolver.resolve((Object)criteria);
                if (clientInformations == null || !clientInformations.iterator().hasNext()) continue;
                return clientInformations;
            }
            catch (ResolverException e) {
                this.log.warn("Error retrieving client information from resolver of type {}, proceeding to next resolver", (Object)resolver.getClass().getName(), (Object)e);
            }
        }
        return Collections.emptyList();
    }

    public void refresh() throws ResolverException {
        for (ClientInformationResolver resolver : this.resolvers) {
            if (!(resolver instanceof RefreshableClientInformationResolver)) continue;
            ((RefreshableClientInformationResolver)resolver).refresh();
        }
    }

    @Nullable
    public Instant getLastUpdate() {
        Instant ret = null;
        for (ClientInformationResolver resolver : this.resolvers) {
            if (!(resolver instanceof RefreshableClientInformationResolver)) continue;
            Instant lastUpdate = ((RefreshableClientInformationResolver)resolver).getLastUpdate();
            if (ret != null && !ret.isBefore(lastUpdate)) continue;
            ret = lastUpdate;
        }
        return ret;
    }

    @Nullable
    public Instant getLastRefresh() {
        Instant ret = null;
        for (ClientInformationResolver resolver : this.resolvers) {
            if (!(resolver instanceof RefreshableClientInformationResolver)) continue;
            Instant lastRefresh = ((RefreshableClientInformationResolver)resolver).getLastRefresh();
            if (ret != null && !ret.isBefore(lastRefresh)) continue;
            ret = lastRefresh;
        }
        return ret;
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.resolvers == null) {
            this.log.warn("ChainingClientInformationResolver was not configured with any member ClientInformationResolvers");
            this.resolvers = Collections.emptyList();
        } else {
            ArrayList<CallSite> resolverDetails = new ArrayList<CallSite>();
            for (ClientInformationResolver resolver : this.resolvers) {
                resolverDetails.add((CallSite)((Object)(resolver.getId() + ": " + this.countClients(resolver) + " clients")));
            }
            this.log.info("ChainingClientInformationResolver was configured with the following resolvers: {}", resolverDetails);
        }
    }

    protected void doDestroy() {
        super.doDestroy();
        this.resolvers = Collections.emptyList();
    }

    protected int countClients(ClientInformationResolver resolver) {
        Iterable iterable;
        int count = 0;
        try {
            iterable = resolver.resolve((Object)new CriteriaSet());
        }
        catch (ResolverException e) {
            this.log.warn("ChainingClientInformationResolver could not count clients for {}", (Object)resolver.getId());
            return 0;
        }
        if (iterable != null) {
            Iterator iterator = iterable.iterator();
            while (iterator.hasNext()) {
                iterator.next();
                ++count;
            }
        }
        return count;
    }
}

