/*
 * Decompiled with CFR 0.152.
 */
package org.geant.idpextension.oidc.metadata.impl;

import com.nimbusds.jose.jwk.Curve;
import com.nimbusds.jose.jwk.ECKey;
import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jose.jwk.KeyUse;
import com.nimbusds.jose.jwk.RSAKey;
import java.security.PublicKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.ECParameterSpec;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minidev.json.JSONArray;
import net.shibboleth.idp.profile.config.SecurityConfiguration;
import net.shibboleth.idp.profile.context.RelyingPartyContext;
import net.shibboleth.utilities.java.support.component.AbstractIdentifiableInitializableComponent;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.logic.ConstraintViolationException;
import net.shibboleth.utilities.java.support.resolver.ResolverException;
import org.geant.idpextension.oidc.metadata.resolver.MetadataValueResolver;
import org.geant.security.jwk.JWKCredential;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.security.credential.Credential;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CredentialMetadataValueResolver
extends AbstractIdentifiableInitializableComponent
implements MetadataValueResolver {
    private final Logger log = LoggerFactory.getLogger(CredentialMetadataValueResolver.class);
    @Nonnull
    private Function<ProfileRequestContext, RelyingPartyContext> relyingPartyContextLookupStrategy = new ChildContextLookup(RelyingPartyContext.class);

    public void setRelyingPartyContextLookupStrategy(@Nonnull Function<ProfileRequestContext, RelyingPartyContext> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.relyingPartyContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"RelyingPartyContext lookup strategy cannot be null");
    }

    public JWK parseJwkCredential(@Nonnull Credential credential) {
        RSAKey jwk;
        KeyUse use;
        Constraint.isNotNull((Object)credential, (String)"Credential cannot be null");
        PublicKey publicKey = credential.getPublicKey();
        String kid = credential instanceof JWKCredential ? ((JWKCredential)credential).getKid() : null;
        switch (credential.getUsageType()) {
            case SIGNING: {
                use = KeyUse.SIGNATURE;
                break;
            }
            case ENCRYPTION: {
                use = KeyUse.ENCRYPTION;
                break;
            }
            default: {
                use = null;
            }
        }
        if (publicKey instanceof RSAPublicKey) {
            RSAKey.Builder builder = new RSAKey.Builder((RSAPublicKey)publicKey).keyID(kid).keyUse(use);
            if (credential instanceof JWKCredential) {
                builder.algorithm(((JWKCredential)credential).getAlgorithm());
            }
            jwk = builder.build();
        } else if (publicKey instanceof ECPublicKey) {
            Curve curve = Curve.forECParameterSpec((ECParameterSpec)((ECPublicKey)publicKey).getParams());
            ECKey.Builder builder = new ECKey.Builder(curve, (ECPublicKey)publicKey);
            if (credential instanceof JWKCredential) {
                builder.algorithm(((JWKCredential)credential).getAlgorithm());
            }
            jwk = builder.build();
        } else {
            this.log.warn("Unsupported public key {}", (Object)publicKey.getAlgorithm());
            throw new ConstraintViolationException("Unsupported public key algorithm");
        }
        return jwk;
    }

    public Iterable<Object> resolve(ProfileRequestContext profileRequestContext) throws ResolverException {
        ArrayList<Object> result = new ArrayList<Object>();
        RelyingPartyContext rpCtx = this.relyingPartyContextLookupStrategy.apply(profileRequestContext);
        if (rpCtx == null || rpCtx.getProfileConfig() == null) {
            this.log.warn("Could not find profile configuration, nothing to do");
            return result;
        }
        SecurityConfiguration securityConfig = rpCtx.getProfileConfig().getSecurityConfiguration(profileRequestContext);
        if (securityConfig == null || securityConfig.getSignatureSigningConfiguration() == null) {
            this.log.warn("Could not find signing configuration, nothing to do");
            return result;
        }
        List credentials = securityConfig.getSignatureSigningConfiguration().getSigningCredentials();
        JSONArray jwkCredentials = new JSONArray();
        for (Credential credential : credentials) {
            try {
                jwkCredentials.add((Object)this.parseJwkCredential(credential).toJSONObject());
            }
            catch (ConstraintViolationException e) {
                this.log.warn("Ignoring key from the resulting list", (Throwable)e);
            }
        }
        result.add(jwkCredentials);
        return result;
    }

    public Object resolveSingle(@Nonnull ProfileRequestContext profileRequestContext) throws ResolverException {
        Iterator<Object> iterator = this.resolve(profileRequestContext).iterator();
        if (iterator.hasNext()) {
            return iterator.next();
        }
        return null;
    }
}

