/*
 * Decompiled with CFR 0.152.
 */
package org.geant.idpextension.oidc.metadata.impl;

import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.id.ClientID;
import com.nimbusds.oauth2.sdk.util.JSONArrayUtils;
import com.nimbusds.oauth2.sdk.util.JSONObjectUtils;
import com.nimbusds.openid.connect.sdk.rp.OIDCClientInformation;
import java.io.IOException;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Timer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minidev.json.JSONArray;
import net.minidev.json.JSONObject;
import net.shibboleth.utilities.java.support.annotation.constraint.Positive;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.DestructableComponent;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import net.shibboleth.utilities.java.support.resolver.ResolverException;
import org.geant.idpextension.oidc.criterion.ClientIDCriterion;
import org.geant.idpextension.oidc.metadata.impl.AbstractFileOIDCEntityResolver;
import org.geant.idpextension.oidc.metadata.resolver.ClientInformationResolver;
import org.geant.idpextension.oidc.metadata.resolver.RefreshableClientInformationResolver;
import org.geant.idpextension.oidc.metadata.resolver.RemoteJwkSetCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;

public class FilesystemClientInformationResolver
extends AbstractFileOIDCEntityResolver<ClientID, OIDCClientInformation>
implements ClientInformationResolver,
RefreshableClientInformationResolver {
    private final Logger log = LoggerFactory.getLogger(FilesystemClientInformationResolver.class);
    private RemoteJwkSetCache remoteJwkSetCache;
    @Positive
    private Duration keyFetchInterval = Duration.ofMinutes(30L);

    public FilesystemClientInformationResolver(@Nonnull Resource metadata) throws IOException {
        super(metadata);
    }

    public FilesystemClientInformationResolver(@Nullable Timer backgroundTaskTimer, @Nonnull Resource metadata) throws IOException {
        super(backgroundTaskTimer, metadata);
    }

    @Override
    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.remoteJwkSetCache == null) {
            this.log.warn("The RemoteJwkSetCache is not defined, the remote keys are not fetched automatically");
        }
    }

    public void setRemoteJwkSetCache(RemoteJwkSetCache jwkSetCache) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        this.remoteJwkSetCache = (RemoteJwkSetCache)Constraint.isNotNull((Object)jwkSetCache, (String)"The remote JWK set cache cannot be null");
    }

    public void setKeyFetchInterval(@Positive Duration interval) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        Constraint.isFalse((interval == null || interval.isNegative() ? 1 : 0) != 0, (String)"Remote key refresh must be greater than 0");
        this.keyFetchInterval = interval;
    }

    public Iterable<OIDCClientInformation> resolve(CriteriaSet criteria) throws ResolverException {
        ComponentSupport.ifNotInitializedThrowUninitializedComponentException((InitializableComponent)this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        ClientIDCriterion clientIdCriterion = (ClientIDCriterion)criteria.get(ClientIDCriterion.class);
        if (clientIdCriterion == null || clientIdCriterion.getClientID() == null) {
            this.log.trace("No client ID criteria found, returning all");
            return this.updateKeys(this.getBackingStore().getOrderedInformation());
        }
        return this.updateKeys(this.lookupIdentifier(clientIdCriterion.getClientID()));
    }

    protected List<OIDCClientInformation> updateKeys(List<OIDCClientInformation> clientInformations) {
        ArrayList<OIDCClientInformation> result = new ArrayList<OIDCClientInformation>();
        for (OIDCClientInformation clientInformation : clientInformations) {
            if (clientInformation.getOIDCMetadata().getJWKSetURI() != null && this.remoteJwkSetCache != null) {
                clientInformation.getOIDCMetadata().setJWKSet(this.remoteJwkSetCache.fetch(clientInformation.getOIDCMetadata().getJWKSetURI(), Instant.now().plus(this.keyFetchInterval)));
            }
            result.add(clientInformation);
        }
        return result;
    }

    public OIDCClientInformation resolveSingle(@Nullable CriteriaSet criteria) throws ResolverException {
        Iterator<OIDCClientInformation> iterator;
        Iterable<OIDCClientInformation> iterable = this.resolve(criteria);
        if (iterable != null && (iterator = iterable.iterator()) != null && iterator.hasNext()) {
            return iterator.next();
        }
        this.log.warn("Could not find any clients with the given criteria");
        return null;
    }

    @Override
    protected List<OIDCClientInformation> parse(@Nonnull byte[] bytes) throws ParseException {
        String rawString = new String(bytes);
        try {
            OIDCClientInformation single = OIDCClientInformation.parse((JSONObject)JSONObjectUtils.parse((String)rawString));
            this.log.debug("Found single client information from the file");
            return Arrays.asList(single);
        }
        catch (ParseException e) {
            this.log.debug("Could not parse single client information from the file, checking for array");
            try {
                JSONArray parsedArray = JSONArrayUtils.parse((String)rawString);
                ArrayList<OIDCClientInformation> result = new ArrayList<OIDCClientInformation>();
                for (Object object : parsedArray) {
                    OIDCClientInformation client = OIDCClientInformation.parse((JSONObject)((JSONObject)object));
                    result.add(client);
                }
                return result;
            }
            catch (ParseException e2) {
                throw new ParseException("Could not parse a single or an array of OIDC client information object(s).");
            }
        }
    }

    @Override
    protected ClientID getKey(@Nonnull OIDCClientInformation value) {
        return value.getID();
    }
}

