/*
 * Decompiled with CFR 0.152.
 */
package org.geant.idpextension.oidc.metadata.impl;

import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.id.Issuer;
import com.nimbusds.oauth2.sdk.util.JSONObjectUtils;
import com.nimbusds.openid.connect.sdk.op.OIDCProviderMetadata;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Timer;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minidev.json.JSONObject;
import net.shibboleth.idp.profile.context.RelyingPartyContext;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.DestructableComponent;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.resolver.ResolverException;
import org.geant.idpextension.oidc.metadata.impl.AbstractFileOIDCEntityResolver;
import org.geant.idpextension.oidc.metadata.resolver.ProviderMetadataResolver;
import org.geant.idpextension.oidc.metadata.resolver.RefreshableProviderMetadataResolver;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;

public class FilesystemProviderMetadataResolver
extends AbstractFileOIDCEntityResolver<Issuer, OIDCProviderMetadata>
implements ProviderMetadataResolver,
RefreshableProviderMetadataResolver {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(FilesystemProviderMetadataResolver.class);
    @Nonnull
    private Function<ProfileRequestContext, RelyingPartyContext> relyingPartyContextLookupStrategy = new ChildContextLookup(RelyingPartyContext.class);

    public FilesystemProviderMetadataResolver(@Nonnull Resource metadata) throws IOException {
        super(metadata);
    }

    public FilesystemProviderMetadataResolver(@Nullable Timer backgroundTaskTimer, @Nonnull Resource metadata) throws IOException {
        super(backgroundTaskTimer, metadata);
    }

    public void setRelyingPartyContextLookupStrategy(@Nonnull Function<ProfileRequestContext, RelyingPartyContext> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.relyingPartyContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"RelyingPartyContext lookup strategy cannot be null");
    }

    @Nullable
    public Iterable<OIDCProviderMetadata> resolve(@Nullable ProfileRequestContext profileRequestContext) throws ResolverException {
        ComponentSupport.ifNotInitializedThrowUninitializedComponentException((InitializableComponent)this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        RelyingPartyContext rpCtx = this.relyingPartyContextLookupStrategy.apply(profileRequestContext);
        List<OIDCProviderMetadata> entities = this.getBackingStore().getOrderedInformation();
        if (rpCtx == null || rpCtx.getConfiguration() == null) {
            this.log.warn("Could not find relying party context, returning all");
            return entities;
        }
        String responderId = rpCtx.getConfiguration().getResponderId(profileRequestContext);
        return entities.stream().filter(e -> e.getIssuer().getValue().equals(responderId)).collect(Collectors.toUnmodifiableList());
    }

    @Nullable
    public OIDCProviderMetadata resolveSingle(@Nullable ProfileRequestContext profileRequestContext) throws ResolverException {
        Iterator<OIDCProviderMetadata> iterator;
        Iterable<OIDCProviderMetadata> iterable = this.resolve(profileRequestContext);
        if (iterable != null && (iterator = iterable.iterator()) != null && iterator.hasNext()) {
            return iterator.next();
        }
        this.log.warn("Could not find any clients with the given criteria");
        return null;
    }

    @Override
    protected List<OIDCProviderMetadata> parse(byte[] bytes) throws ParseException {
        return List.of(OIDCProviderMetadata.parse((JSONObject)JSONObjectUtils.parse((String)new String(bytes))));
    }

    @Override
    protected Issuer getKey(@Nonnull OIDCProviderMetadata value) {
        return value.getIssuer();
    }
}

