/*
 * Decompiled with CFR 0.152.
 */
package org.geant.idpextension.oidc.metadata.impl;

import com.nimbusds.oauth2.sdk.id.ClientID;
import com.nimbusds.openid.connect.sdk.rp.OIDCClientInformation;
import java.io.IOException;
import java.time.Instant;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.geant.idpextension.oidc.metadata.impl.BaseStorageServiceClientInformationComponent;
import org.geant.idpextension.oidc.metadata.impl.StorageServiceClientInformationResolver;
import org.geant.idpextension.oidc.metadata.resolver.ClientInformationManager;
import org.geant.idpextension.oidc.metadata.resolver.ClientInformationManagerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StorageServiceClientInformationManager
extends BaseStorageServiceClientInformationComponent
implements ClientInformationManager {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(StorageServiceClientInformationResolver.class);

    public void storeClientInformation(OIDCClientInformation clientInformation, @Nullable Instant expiration) throws ClientInformationManagerException {
        this.log.debug("Attempting to store client information");
        String clientId = clientInformation.getID().getValue();
        String serialized = clientInformation.toJSONObject().toJSONString();
        try {
            this.getStorageService().create("oidcClientInformation", clientId, serialized, expiration != null ? Long.valueOf(expiration.toEpochMilli()) : null);
        }
        catch (IOException e) {
            this.log.error("Could not store the client information", (Throwable)e);
            throw new ClientInformationManagerException("Could not store the client information", (Exception)e);
        }
        this.log.info("Successfully stored the client information for id {}", (Object)clientId);
    }

    public void destroyClientInformation(ClientID clientId) {
        if (clientId == null) {
            this.log.warn("The null clientId cannot be destroyed, nothing to do");
            return;
        }
        try {
            this.getStorageService().delete("oidcClientInformation", clientId.getValue());
        }
        catch (IOException e) {
            this.log.error("Could not delete the client ID {}", (Object)clientId.getValue(), (Object)e);
        }
    }
}

