/*
 * Decompiled with CFR 0.152.
 */
package org.geant.idpextension.oidc.metadata.impl;

import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.util.JSONObjectUtils;
import com.nimbusds.openid.connect.sdk.rp.OIDCClientInformation;
import java.io.IOException;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minidev.json.JSONObject;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullAfterInit;
import net.shibboleth.utilities.java.support.annotation.constraint.Positive;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.DestructableComponent;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import net.shibboleth.utilities.java.support.resolver.ResolverException;
import org.geant.idpextension.oidc.criterion.ClientIDCriterion;
import org.geant.idpextension.oidc.metadata.impl.BaseStorageServiceClientInformationComponent;
import org.geant.idpextension.oidc.metadata.resolver.ClientInformationResolver;
import org.geant.idpextension.oidc.metadata.resolver.RemoteJwkSetCache;
import org.opensaml.storage.StorageRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StorageServiceClientInformationResolver
extends BaseStorageServiceClientInformationComponent
implements ClientInformationResolver {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(StorageServiceClientInformationResolver.class);
    @NonnullAfterInit
    private RemoteJwkSetCache remoteJwkSetCache;
    @Positive
    private Duration keyFetchInterval = Duration.ofMinutes(30L);

    @Override
    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.remoteJwkSetCache == null) {
            this.log.warn("The RemoteJwkSetCache is not defined, the remote keys are not fetched automatically");
        }
    }

    public void setRemoteJwkSetCache(@Nonnull RemoteJwkSetCache jwkSetCache) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        this.remoteJwkSetCache = (RemoteJwkSetCache)Constraint.isNotNull((Object)jwkSetCache, (String)"The remote JWK set cache cannot be null");
    }

    public void setKeyFetchInterval(@Positive Duration interval) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        Constraint.isFalse((interval == null || interval.isNegative() ? 1 : 0) != 0, (String)"Remote key refresh must be greater than 0");
        this.keyFetchInterval = interval;
    }

    @Nullable
    public Iterable<OIDCClientInformation> resolve(@Nullable CriteriaSet criteria) throws ResolverException {
        ComponentSupport.ifNotInitializedThrowUninitializedComponentException((InitializableComponent)this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        ClientIDCriterion clientIdCriterion = (ClientIDCriterion)criteria.get(ClientIDCriterion.class);
        if (clientIdCriterion == null || clientIdCriterion.getClientID() == null) {
            this.log.warn("No client ID criteria found, returning empty set.");
            return Collections.emptyList();
        }
        String clientId = clientIdCriterion.getClientID().getValue();
        ArrayList<OIDCClientInformation> result = new ArrayList<OIDCClientInformation>();
        try {
            StorageRecord record = this.getStorageService().read("oidcClientInformation", clientId);
            if (record == null) {
                this.log.debug("Could not find any records with clientId {}", (Object)clientId);
            } else {
                OIDCClientInformation clientInformation = OIDCClientInformation.parse((JSONObject)JSONObjectUtils.parse((String)record.getValue()));
                this.log.debug("Found a record with clientId {}", (Object)clientId);
                if (clientInformation.getOIDCMetadata().getJWKSetURI() != null && this.remoteJwkSetCache != null) {
                    clientInformation.getOIDCMetadata().setJWKSet(this.remoteJwkSetCache.fetch(clientInformation.getOIDCMetadata().getJWKSetURI(), Instant.now().plus(this.keyFetchInterval)));
                }
                result.add(clientInformation);
            }
        }
        catch (ParseException | IOException e) {
            this.log.error("Could not read the storage data", e);
        }
        return result;
    }

    @Nullable
    public OIDCClientInformation resolveSingle(@Nullable CriteriaSet criteria) throws ResolverException {
        Iterator<OIDCClientInformation> iterator;
        Iterable<OIDCClientInformation> iterable = this.resolve(criteria);
        if (iterable != null && (iterator = iterable.iterator()) != null && iterator.hasNext()) {
            return iterator.next();
        }
        this.log.warn("Could not find any clients with the given criteria");
        return null;
    }
}

