/*
 * Decompiled with CFR 0.152.
 */
package org.geant.idpextension.oidc.profile.impl;

import com.nimbusds.oauth2.sdk.ErrorObject;
import com.nimbusds.oauth2.sdk.ErrorResponse;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.shibboleth.idp.profile.AbstractProfileAction;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.profile.context.EventContext;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.profile.context.navigate.CurrentOrPreviousEventLookup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractBuildErrorResponseFromEvent<T extends ErrorResponse>
extends AbstractProfileAction {
    public static final String DEFAULT_ERROR_CODE = "invalid_request";
    public static final int DEFAULT_HTTP_STATUS_CODE = 400;
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(AbstractBuildErrorResponseFromEvent.class);
    @Nonnull
    private Function<ProfileRequestContext, EventContext> eventContextLookupStrategy = new CurrentOrPreviousEventLookup();
    private Map<String, ErrorObject> mappedErrors = new HashMap<String, ErrorObject>();
    private int defaultStatusCode = 400;
    private String defaultCode = "invalid_request";

    public void setDefaultStatusCode(int code) {
        this.defaultStatusCode = code;
    }

    public void setDefaultCode(@Nonnull String code) {
        this.defaultCode = (String)Constraint.isNotNull((Object)code, (String)"Default code cannot be null");
    }

    public void setEventContextLookupStrategy(@Nonnull Function<ProfileRequestContext, EventContext> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.eventContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"EventContext lookup strategy cannot be null");
    }

    public void setMappedErrors(@Nonnull Map<String, ErrorObject> errors) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.mappedErrors = (Map)Constraint.isNotNull(errors, (String)"Mapped errors cannot be null");
    }

    protected abstract T buildErrorResponse(ErrorObject var1, ProfileRequestContext var2);

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        if (profileRequestContext.getOutboundMessageContext() == null) {
            this.log.error("{} No outbound message context initialized, nothing to do", (Object)this.getLogPrefix());
            return false;
        }
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        ErrorObject error;
        EventContext eventCtx = this.eventContextLookupStrategy.apply(profileRequestContext);
        if (eventCtx == null || eventCtx.getEvent() == null) {
            this.log.error("{} No event to be included in the response, nothing to do", (Object)this.getLogPrefix());
            return;
        }
        String event = eventCtx.getEvent().toString();
        if (this.mappedErrors.containsKey(event)) {
            this.log.debug("{} Found mapped event for {}", (Object)this.getLogPrefix(), (Object)event);
            error = this.mappedErrors.get(event);
        } else {
            this.log.debug("{} No mapped event found for {}, creating general {}", new Object[]{this.getLogPrefix(), event, this.defaultCode});
            error = new ErrorObject(this.defaultCode, eventCtx.getEvent().toString(), this.defaultStatusCode);
        }
        T errorResponse = this.buildErrorResponse(error, profileRequestContext);
        if (errorResponse != null) {
            profileRequestContext.getOutboundMessageContext().setMessage(this.buildErrorResponse(error, profileRequestContext));
            this.log.debug("{} ErrorResponse successfully set as the outbound message", (Object)this.getLogPrefix());
        } else {
            this.log.debug("{} Error response not formed", (Object)this.getLogPrefix());
        }
    }
}

