/*
 * Decompiled with CFR 0.152.
 */
package org.geant.idpextension.oidc.profile.impl;

import javax.annotation.Nonnull;
import org.geant.idpextension.oidc.messaging.context.OIDCAuthenticationResponseContext;
import org.geant.idpextension.oidc.messaging.context.OIDCMetadataContext;
import org.geant.idpextension.oidc.profile.impl.AbstractOIDCAuthenticationRequestAction;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractOIDCAuthenticationResponseAction
extends AbstractOIDCAuthenticationRequestAction {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(AbstractOIDCAuthenticationResponseAction.class);
    @Nonnull
    private OIDCAuthenticationResponseContext oidcResponseContext;
    @Nonnull
    private OIDCMetadataContext oidcMetadataContext;

    AbstractOIDCAuthenticationResponseAction() {
    }

    @Nonnull
    public OIDCAuthenticationResponseContext getOidcResponseContext() {
        return this.oidcResponseContext;
    }

    public OIDCMetadataContext getMetadataContext() {
        return this.oidcMetadataContext;
    }

    @Override
    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        MessageContext outboundMessageCtx = profileRequestContext.getOutboundMessageContext();
        if (outboundMessageCtx == null) {
            this.log.error("{} No outbound message context", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessageContext");
            return false;
        }
        this.oidcResponseContext = (OIDCAuthenticationResponseContext)outboundMessageCtx.getSubcontext(OIDCAuthenticationResponseContext.class, false);
        if (this.oidcResponseContext == null) {
            this.log.error("{} No oidc response context", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessageContext");
            return false;
        }
        this.oidcMetadataContext = (OIDCMetadataContext)profileRequestContext.getInboundMessageContext().getSubcontext(OIDCMetadataContext.class, false);
        if (this.oidcMetadataContext == null) {
            this.log.error("{} No metadata found for relying party", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessageContext");
            return false;
        }
        return true;
    }
}

