/*
 * Decompiled with CFR 0.152.
 */
package org.geant.idpextension.oidc.profile.impl;

import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.geant.idpextension.oidc.profile.impl.AbstractOIDCResponseAction;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.xmlsec.SignatureSigningParameters;
import org.opensaml.xmlsec.context.SecurityParametersContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractOIDCSigningResponseAction
extends AbstractOIDCResponseAction {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(AbstractOIDCSigningResponseAction.class);
    @Nonnull
    private Function<ProfileRequestContext, SecurityParametersContext> securityParametersLookupStrategy = new ChildContextLookup(SecurityParametersContext.class);
    @Nullable
    private SignatureSigningParameters signatureSigningParameters;

    public void setSecurityParametersLookupStrategy(@Nonnull Function<ProfileRequestContext, SecurityParametersContext> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.securityParametersLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"SecurityParameterContext lookup strategy cannot be null");
    }

    @Nullable
    public SignatureSigningParameters getSignatureSigningParameters() {
        return this.signatureSigningParameters;
    }

    @Override
    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        SecurityParametersContext secParamCtx = this.securityParametersLookupStrategy.apply(profileRequestContext);
        if (secParamCtx == null) {
            this.log.debug("{} no security parameters context is available", (Object)this.getLogPrefix());
            return false;
        }
        this.signatureSigningParameters = secParamCtx.getSignatureSigningParameters();
        if (this.signatureSigningParameters == null || this.signatureSigningParameters.getSigningCredential() == null) {
            this.log.debug("{} no signature signing credentials available", (Object)this.getLogPrefix());
            return false;
        }
        return true;
    }
}

