/*
 * Decompiled with CFR 0.152.
 */
package org.geant.idpextension.oidc.profile.impl;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.geant.idpextension.oidc.messaging.context.OIDCAuthenticationResponseContext;
import org.geant.idpextension.oidc.messaging.context.OIDCMetadataContext;
import org.geant.idpextension.oidc.profile.impl.AbstractOIDCTokenRequestAction;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractOIDCTokenResponseAction
extends AbstractOIDCTokenRequestAction {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(AbstractOIDCTokenResponseAction.class);
    @Nullable
    private OIDCAuthenticationResponseContext oidcResponseContext;
    @Nullable
    private OIDCMetadataContext oidcMetadataContext;

    AbstractOIDCTokenResponseAction() {
    }

    @Nullable
    public OIDCAuthenticationResponseContext getOidcResponseContext() {
        return this.oidcResponseContext;
    }

    @Nullable
    public OIDCMetadataContext getMetadataContext() {
        return this.oidcMetadataContext;
    }

    @Override
    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        MessageContext outboundMessageCtx = profileRequestContext.getOutboundMessageContext();
        if (outboundMessageCtx == null) {
            this.log.error("{} No outbound message context", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessageContext");
            return false;
        }
        this.oidcResponseContext = (OIDCAuthenticationResponseContext)outboundMessageCtx.getSubcontext(OIDCAuthenticationResponseContext.class, false);
        if (this.oidcResponseContext == null) {
            this.log.error("{} No oidc response context", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessageContext");
            return false;
        }
        this.oidcMetadataContext = (OIDCMetadataContext)profileRequestContext.getInboundMessageContext().getSubcontext(OIDCMetadataContext.class, false);
        if (this.oidcMetadataContext == null) {
            this.log.error("{} No metadata found for relying party", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessageContext");
            return false;
        }
        return true;
    }
}

