/*
 * Decompiled with CFR 0.152.
 */
package org.geant.idpextension.oidc.profile.impl;

import com.nimbusds.oauth2.sdk.ResponseType;
import com.nimbusds.openid.connect.sdk.AuthenticationRequest;
import com.nimbusds.openid.connect.sdk.claims.ClaimsSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minidev.json.JSONObject;
import net.shibboleth.idp.attribute.AttributeEncodingException;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.context.AttributeContext;
import net.shibboleth.idp.attribute.transcoding.AttributeTranscoder;
import net.shibboleth.idp.attribute.transcoding.AttributeTranscoderRegistry;
import net.shibboleth.idp.attribute.transcoding.TranscoderSupport;
import net.shibboleth.idp.attribute.transcoding.TranscodingRule;
import net.shibboleth.idp.profile.context.RelyingPartyContext;
import net.shibboleth.utilities.java.support.annotation.constraint.Live;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullAfterInit;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.service.ReloadableService;
import net.shibboleth.utilities.java.support.service.ServiceableComponent;
import org.geant.idpextension.oidc.messaging.context.OIDCAuthenticationResponseConsentContext;
import org.geant.idpextension.oidc.profile.context.navigate.DefaultResponseClaimsSetLookupFunction;
import org.geant.idpextension.oidc.profile.context.navigate.OIDCAuthenticationResponseContextLookupFunction;
import org.geant.idpextension.oidc.profile.impl.AbstractOIDCResponseAction;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddAttributesToClaimsSet
extends AbstractOIDCResponseAction {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(AddAttributesToClaimsSet.class);
    @Nonnull
    private Function<ProfileRequestContext, AttributeContext> attributeContextLookupStrategy = new ChildContextLookup(AttributeContext.class).compose((Function)new ChildContextLookup(RelyingPartyContext.class));
    @Nonnull
    private Function<ProfileRequestContext, ClaimsSet> responseClaimsSetLookupStrategy = new DefaultResponseClaimsSetLookupFunction();
    @Nonnull
    private Function<ProfileRequestContext, OIDCAuthenticationResponseConsentContext> consentContextLookupStrategy = new ChildContextLookup(OIDCAuthenticationResponseConsentContext.class).compose((Function)new OIDCAuthenticationResponseContextLookupFunction());
    @NonnullAfterInit
    private ReloadableService<AttributeTranscoderRegistry> transcoderRegistry;
    private boolean ignoringUnencodableAttributes = true;
    @Nullable
    private AttributeContext attributeCtx;
    @Nullable
    private ClaimsSet claimsSet;
    @Nonnull
    private boolean targetIDToken;
    @Nonnull
    private boolean addToIDTokenByDefault;
    @Nullable
    private List<String> reservedClaimNames;

    AddAttributesToClaimsSet() {
    }

    public void setTranscoderRegistry(@Nonnull ReloadableService<AttributeTranscoderRegistry> registry) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.transcoderRegistry = (ReloadableService)Constraint.isNotNull(registry, (String)"AttributeTranscoderRegistry cannot be null");
    }

    public void setIgnoringUnencodableAttributes(boolean flag) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.ignoringUnencodableAttributes = flag;
    }

    public void setReservedClaimNames(List<String> claimNames) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.reservedClaimNames = claimNames;
    }

    public void setTargetIDToken(boolean flag) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.targetIDToken = flag;
    }

    public void setResponseClaimsSetLookupStrategy(@Nonnull Function<ProfileRequestContext, ClaimsSet> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.responseClaimsSetLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Response Claims Set lookup strategy cannot be null");
    }

    public void setAttributeContextLookupStrategy(@Nonnull Function<ProfileRequestContext, AttributeContext> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.attributeContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"AttributeContext lookup strategy cannot be null");
    }

    public void setOIDCAuthenticationResponseConsentContextLookupStrategy(@Nonnull Function<ProfileRequestContext, OIDCAuthenticationResponseConsentContext> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.consentContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"OIDCAuthenticationResponseConsentContext lookup strategy cannot be null");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.transcoderRegistry == null) {
            throw new ComponentInitializationException("AttributeTranscoderRegistry cannot be null");
        }
    }

    @Override
    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        Object msg;
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        this.attributeCtx = this.attributeContextLookupStrategy.apply(profileRequestContext);
        if (this.attributeCtx == null) {
            this.log.debug("{} No AttributeSubcontext available, nothing to do", (Object)this.getLogPrefix());
            return false;
        }
        this.claimsSet = this.responseClaimsSetLookupStrategy.apply(profileRequestContext);
        if (this.claimsSet == null) {
            this.log.error("{} No claims set to fill", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessageContext");
            return false;
        }
        if (this.targetIDToken && (msg = profileRequestContext.getInboundMessageContext().getMessage()) instanceof AuthenticationRequest) {
            this.addToIDTokenByDefault = !((AuthenticationRequest)msg).getResponseType().contains((Object)ResponseType.Value.TOKEN);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        ArrayList<JSONObject> claims = new ArrayList<JSONObject>();
        ServiceableComponent component = null;
        try {
            component = this.transcoderRegistry.getServiceableComponent();
            if (component == null) {
                this.log.error("Attribute transoding service unavailable");
                throw new AttributeEncodingException("Attribute transoding service unavailable");
            }
            for (IdPAttribute attribute : this.attributeCtx.getIdPAttributes().values()) {
                if (attribute == null || attribute.getValues().isEmpty()) continue;
                this.encodeAttribute((AttributeTranscoderRegistry)component.getComponent(), profileRequestContext, attribute, claims);
            }
        }
        catch (AttributeEncodingException e) {
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"UnableToEncodeAttribute");
            return;
        }
        finally {
            if (null != component) {
                component.unpinComponent();
            }
        }
        OIDCAuthenticationResponseConsentContext consentCtx = this.consentContextLookupStrategy.apply(profileRequestContext);
        for (JSONObject claim : claims) {
            for (String name : claim.keySet()) {
                if (this.reservedClaimNames != null && this.reservedClaimNames.contains(name)) {
                    this.log.debug("{} claim has a reserved name {}. Not added to claims set", (Object)this.getLogPrefix(), (Object)name);
                    continue;
                }
                if (consentCtx != null && consentCtx.getConsentableAttributes().contains((Object)name) && !consentCtx.getConsentedAttributes().contains((Object)name)) {
                    this.log.debug("{} Consentable attribute {} has no consent. Not added to claims set", (Object)this.getLogPrefix(), (Object)name);
                    continue;
                }
                this.log.debug("{} Adding claim {} with value {}", new Object[]{this.getLogPrefix(), name, claim.get((Object)name)});
                this.claimsSet.setClaim(name, claim.get((Object)name));
            }
        }
        this.log.debug("{} claims set after mapping attributes to claims {}", (Object)this.getLogPrefix(), (Object)this.claimsSet.toJSONObject().toJSONString());
    }

    private void encodeAttribute(@Nonnull AttributeTranscoderRegistry registry, @Nonnull ProfileRequestContext profileRequestContext, @Nonnull IdPAttribute attribute, @Nonnull @NonnullElements @Live Collection<JSONObject> results) throws AttributeEncodingException {
        Collection transcodingRules = registry.getTranscodingRules(attribute, JSONObject.class);
        if (transcodingRules.isEmpty()) {
            this.log.debug("{} Attribute {} does not have any transcoding rules, nothing to do", (Object)this.getLogPrefix(), (Object)attribute.getId());
            return;
        }
        for (TranscodingRule rule : transcodingRules) {
            try {
                AttributeTranscoder transcoder;
                JSONObject encodedAttribute;
                if (this.targetIDToken) {
                    if (!this.addToIDTokenByDefault && !((Boolean)rule.getOrDefault("oidc.forceIDToken", Boolean.class, (Object)false)).booleanValue()) {
                        this.log.debug("{} Attribute {} not targeted for ID Token", (Object)this.getLogPrefix(), (Object)attribute.getId());
                        continue;
                    }
                } else if (((Boolean)rule.getOrDefault("oidc.denyUserInfo", Boolean.class, (Object)false)).booleanValue()) {
                    this.log.debug("{} Attribute {} not targeted for Userinfo response", (Object)this.getLogPrefix(), (Object)attribute.getId());
                    continue;
                }
                if ((encodedAttribute = (JSONObject)(transcoder = TranscoderSupport.getTranscoder((TranscodingRule)rule)).encode(profileRequestContext, attribute, JSONObject.class, rule)) == null) continue;
                results.add(encodedAttribute);
            }
            catch (AttributeEncodingException e) {
                this.log.warn("{} Unable to encode attribute {}", new Object[]{this.getLogPrefix(), attribute.getId(), e});
                if (this.ignoringUnencodableAttributes) continue;
                throw e;
            }
        }
    }
}

