/*
 * Decompiled with CFR 0.152.
 */
package org.geant.idpextension.oidc.profile.impl;

import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.oauth2.sdk.AuthorizationCode;
import com.nimbusds.openid.connect.sdk.claims.CodeHash;
import javax.annotation.Nonnull;
import org.geant.idpextension.oidc.profile.impl.AbstractOIDCSigningResponseAction;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddAuthorizationCodeHashToIDToken
extends AbstractOIDCSigningResponseAction {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(AddAuthorizationCodeHashToIDToken.class);

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (this.getOidcResponseContext().getIDToken() == null) {
            this.log.error("{} No id token", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessageContext");
            return;
        }
        if (this.getOidcResponseContext().getAuthorizationCode() == null) {
            this.log.error("{} No authz code to calculate hash on", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessageContext");
            return;
        }
        CodeHash cHash = CodeHash.compute((AuthorizationCode)this.getOidcResponseContext().getAuthorizationCode(), (JWSAlgorithm)new JWSAlgorithm(this.getSignatureSigningParameters().getSignatureAlgorithm()));
        if (cHash == null || cHash.getValue() == null) {
            this.log.error("{} Not able to generate c_hash using algorithm {}", (Object)this.getLogPrefix(), (Object)this.getSignatureSigningParameters().getSignatureAlgorithm());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidSecurityConfiguration");
            return;
        }
        this.log.debug("{} Setting authz code hash to id token", (Object)this.getLogPrefix());
        this.getOidcResponseContext().getIDToken().setClaim("c_hash", (Object)cHash.getValue());
        this.log.debug("{} Updated token {}", (Object)this.getLogPrefix(), (Object)this.getOidcResponseContext().getIDToken().toJSONObject().toJSONString());
    }
}

