/*
 * Decompiled with CFR 0.152.
 */
package org.geant.idpextension.oidc.profile.impl;

import com.nimbusds.langtag.LangTag;
import java.util.Map;
import javax.annotation.Nonnull;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.geant.idpextension.oidc.profile.impl.AbstractOIDCClientMetadataPopulationAction;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddClientNameToClientMetadata
extends AbstractOIDCClientMetadataPopulationAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(AddClientNameToClientMetadata.class);

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        String nameNoTag = StringSupport.trimOrNull((String)this.getInputMetadata().getName());
        Map map = this.getInputMetadata().getNameEntries();
        if (nameNoTag != null) {
            this.log.debug("{} Found client name without name tag: {}", (Object)this.getLogPrefix(), (Object)nameNoTag);
            this.getOutputMetadata().setName(nameNoTag, null);
        }
        if (map != null && !map.isEmpty()) {
            for (LangTag tag : map.keySet()) {
                String name = StringSupport.trimOrNull((String)((String)map.get(tag)));
                if (name == null) continue;
                this.log.debug("{} Found client name {} for language tag {}", new Object[]{this.getLogPrefix(), name, tag});
                this.getOutputMetadata().setName(name, tag);
            }
        }
    }
}

