/*
 * Decompiled with CFR 0.152.
 */
package org.geant.idpextension.oidc.profile.impl;

import com.nimbusds.jose.EncryptionMethod;
import com.nimbusds.jose.JWEAlgorithm;
import com.nimbusds.jose.JWSAlgorithm;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.geant.idpextension.oidc.config.navigate.DataEncryptionAlgorithmsLookupFunction;
import org.geant.idpextension.oidc.config.navigate.KeyTransportEncryptionAlgorithmsLookupFunction;
import org.geant.idpextension.oidc.config.navigate.SignatureAlgorithmsLookupFunction;
import org.geant.idpextension.oidc.profile.impl.AbstractOIDCClientMetadataPopulationAction;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddRequestObjectSecurityConfigurationToClientMetadata
extends AbstractOIDCClientMetadataPopulationAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(AddRequestObjectSecurityConfigurationToClientMetadata.class);
    @Nullable
    private Function<ProfileRequestContext, List<String>> signatureAlgorithmsLookupStrategy = new SignatureAlgorithmsLookupFunction();
    @Nullable
    private Function<ProfileRequestContext, List<String>> dataEncryptionAlgorithmsLookupStrategy = new DataEncryptionAlgorithmsLookupFunction();
    @Nullable
    private Function<ProfileRequestContext, List<String>> keyTransportEncryptionAlgorithmsLookupStrategy = new KeyTransportEncryptionAlgorithmsLookupFunction();
    private boolean allowSignatureNone;
    @Nullable
    private List<String> supportedSignatureValidationAlgs;
    @Nullable
    private List<String> supportedDecryptionEncs;
    @Nullable
    private List<String> supportedDecryptionAlgs;

    public void setAllowSignatureNone(boolean allow) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.allowSignatureNone = allow;
    }

    public void setSignatureAlgorithmsLookupStrategy(@Nonnull Function<ProfileRequestContext, List<String>> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.signatureAlgorithmsLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Signature algorithms lookup strategy cannot be null");
    }

    public void setDataEncryptionAlgorithmsLookupStrategy(@Nonnull Function<ProfileRequestContext, List<String>> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.dataEncryptionAlgorithmsLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Data encryption algorithms lookup strategy cannot be null");
    }

    public void setKeyTransportAlgorithmsLookupStrategy(@Nonnull Function<ProfileRequestContext, List<String>> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.keyTransportEncryptionAlgorithmsLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Key transport encryption algorithms lookup strategy cannot be null");
    }

    @Override
    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        this.supportedSignatureValidationAlgs = this.signatureAlgorithmsLookupStrategy.apply(profileRequestContext);
        if (this.supportedSignatureValidationAlgs.isEmpty()) {
            this.log.warn("{} No supported signature validation algorithms resolved", (Object)this.getLogPrefix());
        }
        this.supportedDecryptionAlgs = this.keyTransportEncryptionAlgorithmsLookupStrategy.apply(profileRequestContext);
        if (this.supportedDecryptionAlgs.isEmpty()) {
            this.log.warn("{} No supported key transport decryption algorithms resolved", (Object)this.getLogPrefix());
        }
        this.supportedDecryptionEncs = this.dataEncryptionAlgorithmsLookupStrategy.apply(profileRequestContext);
        if (this.supportedDecryptionEncs.isEmpty()) {
            this.log.warn("{} No supported data decryption algorithms resolved", (Object)this.getLogPrefix());
        }
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        EncryptionMethod reqRequestObjectEncEnc;
        JWEAlgorithm reqRequestObjectEncAlg;
        JWSAlgorithm reqRequestObjectSigAlg = this.getInputMetadata().getRequestObjectJWSAlg();
        if (reqRequestObjectSigAlg != null) {
            if ("none".equals(reqRequestObjectSigAlg.getName()) && this.allowSignatureNone || this.supportedSignatureValidationAlgs.contains(reqRequestObjectSigAlg.getName())) {
                this.getOutputMetadata().setRequestObjectJWSAlg(reqRequestObjectSigAlg);
            } else {
                this.log.warn("{} The requested request_object_signing_alg {} is not supported", (Object)this.getLogPrefix(), (Object)reqRequestObjectSigAlg.getName());
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessage");
                return;
            }
        }
        if ((reqRequestObjectEncAlg = this.getInputMetadata().getRequestObjectJWEAlg()) == null != ((reqRequestObjectEncEnc = this.getInputMetadata().getRequestObjectJWEEnc()) == null)) {
            if (reqRequestObjectEncAlg == null) {
                this.log.warn("{} The requested request_object_encryption_alg was not defined even though _enc was", (Object)this.getLogPrefix());
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessage");
                return;
            }
            this.log.debug("{} Using default algorithm for request_object_encryption_enc", (Object)this.getLogPrefix());
            this.getOutputMetadata().setRequestObjectJWEEnc(EncryptionMethod.A128CBC_HS256);
            this.getOutputMetadata().setRequestObjectJWEAlg(reqRequestObjectEncAlg);
        } else {
            this.getOutputMetadata().setRequestObjectJWEAlg(this.getInputMetadata().getRequestObjectJWEAlg());
            this.getOutputMetadata().setRequestObjectJWEEnc(this.getInputMetadata().getRequestObjectJWEEnc());
        }
        if (this.getOutputMetadata().getRequestObjectJWEAlg() != null && !this.supportedDecryptionAlgs.contains(this.getOutputMetadata().getRequestObjectJWEAlg().getName())) {
            this.log.warn("{} The requested response_object_encryption_alg {} is not supported", (Object)this.getLogPrefix(), (Object)this.getOutputMetadata().getRequestObjectJWEAlg());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessage");
            return;
        }
        if (this.getOutputMetadata().getRequestObjectJWEEnc() != null && !this.supportedDecryptionEncs.contains(this.getOutputMetadata().getRequestObjectJWEEnc().getName())) {
            this.log.warn("{} The requested response_object_encryption_enc {} is not supported", (Object)this.getLogPrefix(), (Object)this.getOutputMetadata().getRequestObjectJWEEnc());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessage");
            return;
        }
    }
}

