/*
 * Decompiled with CFR 0.152.
 */
package org.geant.idpextension.oidc.profile.impl;

import com.nimbusds.oauth2.sdk.ResponseType;
import com.nimbusds.openid.connect.sdk.OIDCResponseTypeValue;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.logic.PredicateSupport;
import org.geant.idpextension.oidc.config.logic.AuthorizationCodeFlowEnabledPredicate;
import org.geant.idpextension.oidc.config.logic.ImplicitFlowEnabledPredicate;
import org.geant.idpextension.oidc.profile.impl.AbstractOIDCClientMetadataPopulationAction;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddResponseTypesToClientMetadata
extends AbstractOIDCClientMetadataPopulationAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(AddResponseTypesToClientMetadata.class);
    @Nonnull
    private Predicate<ProfileRequestContext> authorizationCodeFlowPredicate = new AuthorizationCodeFlowEnabledPredicate();
    @Nonnull
    private Predicate<ProfileRequestContext> implicitFlowPredicate = new ImplicitFlowEnabledPredicate();
    @Nonnull
    private Map<ResponseType, Predicate<ProfileRequestContext>> supportedResponseTypes = new HashMap<ResponseType, Predicate<ProfileRequestContext>>();

    public AddResponseTypesToClientMetadata() {
        this.supportedResponseTypes.put(new ResponseType(new ResponseType.Value[]{ResponseType.Value.CODE}), this.authorizationCodeFlowPredicate);
        this.supportedResponseTypes.put(new ResponseType(new ResponseType.Value[]{OIDCResponseTypeValue.ID_TOKEN}), this.implicitFlowPredicate);
        this.supportedResponseTypes.put(new ResponseType(new ResponseType.Value[]{ResponseType.Value.TOKEN, OIDCResponseTypeValue.ID_TOKEN}), this.implicitFlowPredicate);
        this.supportedResponseTypes.put(new ResponseType(new ResponseType.Value[]{ResponseType.Value.CODE, OIDCResponseTypeValue.ID_TOKEN}), (Predicate<ProfileRequestContext>)PredicateSupport.and(this.implicitFlowPredicate, this.authorizationCodeFlowPredicate));
        this.supportedResponseTypes.put(new ResponseType(new ResponseType.Value[]{ResponseType.Value.CODE, ResponseType.Value.TOKEN}), (Predicate<ProfileRequestContext>)PredicateSupport.and(this.implicitFlowPredicate, this.authorizationCodeFlowPredicate));
        this.supportedResponseTypes.put(new ResponseType(new ResponseType.Value[]{ResponseType.Value.CODE, ResponseType.Value.TOKEN, OIDCResponseTypeValue.ID_TOKEN}), (Predicate<ProfileRequestContext>)PredicateSupport.and(this.implicitFlowPredicate, this.authorizationCodeFlowPredicate));
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
    }

    public Predicate<ProfileRequestContext> getAuthorizationCodeFlowEnabled() {
        return this.authorizationCodeFlowPredicate;
    }

    public void setAuthorizationCodeFlowEnabled(Predicate<ProfileRequestContext> predicate) {
        this.authorizationCodeFlowPredicate = (Predicate)Constraint.isNotNull(predicate, (String)"Predicate used to indicate whether authorization code flow is supported cannot be null");
    }

    public Predicate<ProfileRequestContext> getImplicitFlowEnabled() {
        return this.implicitFlowPredicate;
    }

    public void setImplicitFlowEnabled(Predicate<ProfileRequestContext> predicate) {
        this.implicitFlowPredicate = (Predicate)Constraint.isNotNull(predicate, (String)"Predicate used to indicate whether hybrid flow is supported cannot be null");
    }

    public void setSupportedResponseTypes(Map<ResponseType, Predicate<ProfileRequestContext>> types) {
        this.supportedResponseTypes = (Map)Constraint.isNotNull(types, (String)"Supported response types cannot be null!");
    }

    public Map<ResponseType, Predicate<ProfileRequestContext>> getSupportedResponseTypes() {
        return this.supportedResponseTypes;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        Set requestedTypes = this.getInputMetadata().getResponseTypes();
        HashSet<ResponseType> responseTypes = new HashSet<ResponseType>();
        if (requestedTypes != null && !requestedTypes.isEmpty()) {
            for (ResponseType requestedType : requestedTypes) {
                if (this.supportedResponseTypes.keySet().contains(requestedType)) {
                    this.addResponseTypeIfEnabled(responseTypes, requestedType, this.supportedResponseTypes.get(requestedType), profileRequestContext);
                    continue;
                }
                this.log.warn("{} Dropping unsupported requested response type {}", (Object)this.getLogPrefix(), (Object)requestedType);
            }
            if (responseTypes.isEmpty()) {
                this.log.error("{} No supported response types requested", (Object)this.getLogPrefix());
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessage");
                return;
            }
        } else {
            this.addResponseTypeIfEnabled(responseTypes, new ResponseType(new ResponseType.Value[]{ResponseType.Value.CODE}), this.authorizationCodeFlowPredicate, profileRequestContext);
        }
        this.getOutputMetadata().setResponseTypes(responseTypes);
    }

    protected void addResponseTypeIfEnabled(Set<ResponseType> resultTypes, ResponseType responseType, Predicate<ProfileRequestContext> predicate, ProfileRequestContext profileRequestContext) {
        if (predicate.test(profileRequestContext)) {
            this.log.debug("{} Adding {} to the list of enabled types", (Object)this.getLogPrefix(), (Object)responseType);
            resultTypes.add(responseType);
        } else {
            this.log.debug("{} Response type {} is not enabled", (Object)this.getLogPrefix(), (Object)responseType);
        }
    }
}

