/*
 * Decompiled with CFR 0.152.
 */
package org.geant.idpextension.oidc.profile.impl;

import com.nimbusds.oauth2.sdk.Scope;
import com.nimbusds.openid.connect.sdk.OIDCScopeValue;
import javax.annotation.Nonnull;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.geant.idpextension.oidc.profile.impl.AbstractOIDCClientMetadataPopulationAction;
import org.geant.idpextension.oidc.profile.impl.AddRedirectUrisToClientMetadata;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddScopeToClientMetadata
extends AbstractOIDCClientMetadataPopulationAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(AddRedirectUrisToClientMetadata.class);
    @Nonnull
    private Scope defaultScope = new Scope();

    public AddScopeToClientMetadata() {
        this.defaultScope.add((Object)OIDCScopeValue.OPENID);
    }

    public void setDefaultScope(@Nonnull Scope scope) {
        this.defaultScope = (Scope)Constraint.isNotNull((Object)scope, (String)"The default scope cannot be null");
    }

    @Nonnull
    public Scope getDefaultScope() {
        return this.defaultScope;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        Scope requestScope = this.getInputMetadata().getScope();
        if (requestScope == null || requestScope.isEmpty()) {
            this.log.debug("{} Scope in the request was null, adding default scope", (Object)this.getLogPrefix());
            this.getOutputMetadata().setScope(this.defaultScope);
        } else {
            this.getOutputMetadata().setScope(requestScope);
        }
    }
}

