/*
 * Decompiled with CFR 0.152.
 */
package org.geant.idpextension.oidc.profile.impl;

import com.nimbusds.openid.connect.sdk.SubjectType;
import javax.annotation.Nonnull;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.geant.idpextension.oidc.profile.impl.AbstractOIDCClientMetadataPopulationAction;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddSubjectTypeToClientMetadata
extends AbstractOIDCClientMetadataPopulationAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(AddSubjectTypeToClientMetadata.class);
    private SubjectType defaultSubjectType = SubjectType.PUBLIC;

    public void setDefaultSubjectType(SubjectType subjectType) {
        this.defaultSubjectType = (SubjectType)Constraint.isNotNull((Object)subjectType, (String)"The default subjectType cannot be null");
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        SubjectType requestedType = this.getInputMetadata().getSubjectType();
        if (requestedType == null) {
            this.log.debug("{} No subject type requested, using default {}", (Object)this.getLogPrefix(), (Object)this.defaultSubjectType);
            this.getOutputMetadata().setSubjectType(this.defaultSubjectType);
        } else {
            this.getOutputMetadata().setSubjectType(requestedType);
        }
    }
}

