/*
 * Decompiled with CFR 0.152.
 */
package org.geant.idpextension.oidc.profile.impl;

import com.nimbusds.oauth2.sdk.auth.ClientAuthenticationMethod;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.geant.idpextension.oidc.config.navigate.TokenEndpointAuthMethodLookupFunction;
import org.geant.idpextension.oidc.profile.impl.AbstractOIDCClientMetadataPopulationAction;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddTokenEndpointAuthMethodsToClientMetadata
extends AbstractOIDCClientMetadataPopulationAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(AddTokenEndpointAuthMethodsToClientMetadata.class);
    @Nullable
    private Function<ProfileRequestContext, List<ClientAuthenticationMethod>> tokenEndpointAuthMethodsLookupStrategy = new TokenEndpointAuthMethodLookupFunction();

    public void setTokenEndpointAuthMethodsLookupStrategy(@Nonnull Function<ProfileRequestContext, List<ClientAuthenticationMethod>> strategy) {
        this.tokenEndpointAuthMethodsLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Strategy to obtain enabled token endpoint authentication methods cannot be null");
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        ClientAuthenticationMethod requestedMethod = this.getInputMetadata().getTokenEndpointAuthMethod() != null ? this.getInputMetadata().getTokenEndpointAuthMethod() : ClientAuthenticationMethod.getDefault();
        List<ClientAuthenticationMethod> enabledMethods = this.tokenEndpointAuthMethodsLookupStrategy.apply(profileRequestContext);
        if (enabledMethods == null || !enabledMethods.contains(requestedMethod)) {
            this.log.warn("{} Non-supported token_endpoint_auth_method {}", (Object)this.getLogPrefix(), (Object)requestedMethod);
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessage");
            return;
        }
        this.getOutputMetadata().setTokenEndpointAuthMethod(requestedMethod);
    }
}

