/*
 * Decompiled with CFR 0.152.
 */
package org.geant.idpextension.oidc.profile.impl;

import com.nimbusds.oauth2.sdk.auth.ClientAuthenticationMethod;
import com.nimbusds.oauth2.sdk.auth.Secret;
import com.nimbusds.oauth2.sdk.id.ClientID;
import com.nimbusds.openid.connect.sdk.rp.OIDCClientInformation;
import com.nimbusds.openid.connect.sdk.rp.OIDCClientInformationResponse;
import com.nimbusds.openid.connect.sdk.rp.OIDCClientMetadata;
import java.time.Instant;
import java.util.Date;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.shibboleth.idp.profile.AbstractProfileAction;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.geant.idpextension.oidc.messaging.context.OIDCClientRegistrationResponseContext;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BuildClientInformation
extends AbstractProfileAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(BuildClientInformation.class);
    @Nonnull
    private Function<MessageContext, OIDCClientRegistrationResponseContext> oidcResponseContextLookupStrategy = new ChildContextLookup(OIDCClientRegistrationResponseContext.class);

    public void setOidcResponseContextLookupStrategy(@Nonnull Function<MessageContext, OIDCClientRegistrationResponseContext> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.oidcResponseContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"OIDCClientRegistrationResponseContext lookup strategy cannot be null");
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        Instant secretExpiresAt;
        boolean secretNeeded;
        OIDCClientRegistrationResponseContext oidcContext = this.oidcResponseContextLookupStrategy.apply(profileRequestContext.getOutboundMessageContext());
        ClientID clientId = new ClientID(oidcContext.getClientId());
        OIDCClientMetadata metadata = oidcContext.getClientMetadata();
        ClientAuthenticationMethod tokenAuthMethod = metadata.getTokenEndpointAuthMethod();
        boolean bl = secretNeeded = tokenAuthMethod.equals((Object)ClientAuthenticationMethod.CLIENT_SECRET_BASIC) || tokenAuthMethod.equals((Object)ClientAuthenticationMethod.CLIENT_SECRET_JWT) || tokenAuthMethod.equals((Object)ClientAuthenticationMethod.CLIENT_SECRET_POST);
        Secret clientSecret = secretNeeded && oidcContext.getClientSecret() != null ? ((secretExpiresAt = oidcContext.getClientSecretExpiresAt()) != null ? new Secret(oidcContext.getClientSecret(), Date.from(secretExpiresAt)) : new Secret(oidcContext.getClientSecret())) : null;
        OIDCClientInformation clientInformation = new OIDCClientInformation(clientId, new Date(), metadata, clientSecret);
        OIDCClientInformationResponse response = new OIDCClientInformationResponse(clientInformation, true);
        profileRequestContext.getOutboundMessageContext().setMessage((Object)response);
        this.log.info("{} Client information successfully added to the outbound context", (Object)this.getLogPrefix());
    }
}

