/*
 * Decompiled with CFR 0.152.
 */
package org.geant.idpextension.oidc.profile.impl;

import com.google.gson.Gson;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletResponse;
import net.shibboleth.idp.profile.AbstractProfileAction;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullAfterInit;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.geant.idpextension.oidc.messaging.OIDCWebFingerRequest;
import org.geant.idpextension.oidc.messaging.OIDCWebFingerResponse;
import org.geant.idpextension.oidc.messaging.impl.OIDCWebFingerResponseImpl;
import org.geant.idpextension.oidc.messaging.impl.OIDCWebFingerResponseLinkImpl;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BuildWebFingerResponse
extends AbstractProfileAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(BuildWebFingerResponse.class);
    @NonnullAfterInit
    private String oidcIssuer;
    @Nullable
    private OIDCWebFingerRequest request;

    public void setIssuer(@Nonnull @NotEmpty String issuer) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.oidcIssuer = Constraint.isNotEmpty((String)issuer, (String)"Issuer cannot be null!");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.oidcIssuer == null) {
            throw new ComponentInitializationException("Issuer cannot be null");
        }
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        if (profileRequestContext.getInboundMessageContext() == null) {
            this.log.debug("{} No inbound message context associated with this profile request", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
            return false;
        }
        Object message = profileRequestContext.getInboundMessageContext().getMessage();
        if (message == null || !(message instanceof OIDCWebFingerRequest)) {
            this.log.debug("{} No inbound message associated with this profile request", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessageContext");
            return false;
        }
        this.request = (OIDCWebFingerRequest)message;
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        HttpServletResponse servletResponse = this.getHttpServletResponse();
        OIDCWebFingerResponseLinkImpl link = new OIDCWebFingerResponseLinkImpl(this.request.getRel(), this.oidcIssuer);
        ArrayList<OIDCWebFingerResponse.Link> links = new ArrayList<OIDCWebFingerResponse.Link>();
        links.add(link);
        OIDCWebFingerResponseImpl response = new OIDCWebFingerResponseImpl(this.request.getResource(), links);
        servletResponse.setContentType("application/jrd+json");
        servletResponse.setCharacterEncoding("UTF-8");
        Gson gson = new Gson();
        try {
            gson.toJson(gson.toJsonTree((Object)response), gson.newJsonWriter((Writer)servletResponse.getWriter()));
        }
        catch (IOException e) {
            this.log.error("{} Could not encode the JSON response to the servlet response", (Object)this.getLogPrefix(), (Object)e);
            return;
        }
        this.log.debug("{} WebFinger response successfully applied to the HTTP response", (Object)this.getLogPrefix());
    }
}

