/*
 * Decompiled with CFR 0.152.
 */
package org.geant.idpextension.oidc.profile.impl;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import com.nimbusds.oauth2.sdk.GrantType;
import com.nimbusds.openid.connect.sdk.rp.ApplicationType;
import com.nimbusds.openid.connect.sdk.rp.OIDCClientMetadata;
import com.nimbusds.openid.connect.sdk.rp.OIDCClientRegistrationRequest;
import java.io.IOException;
import java.lang.reflect.Type;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.profile.AbstractProfileAction;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullAfterInit;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.DestructableComponent;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.ParseException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.security.httpclient.HttpClientSecurityParameters;
import org.opensaml.security.httpclient.HttpClientSecuritySupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CheckRedirectURIs
extends AbstractProfileAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(CheckRedirectURIs.class);
    @Nullable
    private OIDCClientRegistrationRequest request;
    @NonnullAfterInit
    private HttpClient httpClient;
    @Nullable
    private HttpClientSecurityParameters httpClientSecurityParameters;

    public void setHttpClient(@Nonnull HttpClient client) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        this.httpClient = (HttpClient)Constraint.isNotNull((Object)client, (String)"HttpClient cannot be null");
    }

    public void setHttpClientSecurityParameters(@Nullable HttpClientSecurityParameters params) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        this.httpClientSecurityParameters = params;
    }

    public void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.httpClient == null) {
            throw new ComponentInitializationException(this.getLogPrefix() + " HttpClient cannot be null");
        }
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        if (profileRequestContext.getInboundMessageContext() == null) {
            this.log.debug("{} No inbound message context associated with this profile request", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
            return false;
        }
        Object message = profileRequestContext.getInboundMessageContext().getMessage();
        if (message == null || !(message instanceof OIDCClientRegistrationRequest)) {
            this.log.debug("{} No inbound message associated with this profile request", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessageContext");
            return false;
        }
        this.request = (OIDCClientRegistrationRequest)message;
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        ApplicationType applicationType;
        OIDCClientMetadata metadata = this.request.getOIDCClientMetadata();
        if (metadata == null) {
            this.log.warn("{} No client metadata found in the request", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessage");
            return;
        }
        Set redirectURIs = metadata.getRedirectionURIs();
        if (redirectURIs == null || redirectURIs.isEmpty()) {
            this.log.warn("{} No redirection URIs found in the request", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"MissingRedirectionURIs");
            return;
        }
        URI sectorIdUri = metadata.getSectorIDURI();
        if (sectorIdUri != null) {
            this.log.debug("{} Found sector_identifier_uri {}", (Object)this.getLogPrefix(), (Object)sectorIdUri);
            if (!sectorIdUri.getScheme().equals("https")) {
                this.log.warn("{} Invalid sector_identifier_uri scheme {}", (Object)this.getLogPrefix(), (Object)sectorIdUri.getScheme());
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessage");
                return;
            }
            if (!this.verifySectorIdUri(sectorIdUri, redirectURIs)) {
                this.log.warn("{} All redirect URIs are not found from sector_identifier_uri", (Object)this.getLogPrefix());
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidRedirectionURIs");
                return;
            }
        }
        if ((applicationType = metadata.getApplicationType()) == null || applicationType.equals((Object)ApplicationType.WEB)) {
            Set grantTypes = metadata.getGrantTypes();
            if (grantTypes != null && grantTypes.contains(GrantType.IMPLICIT) && !this.checkScheme(redirectURIs, "https")) {
                this.log.warn("{} Only https-scheme is allowed for implicit flow", (Object)this.getLogPrefix());
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidRedirectionURIs");
                return;
            }
            if (this.checkForbiddenHostname(redirectURIs, "localhost")) {
                this.log.warn("{} localhost as the hostname in the redirect URI for a Web app", (Object)this.getLogPrefix());
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidRedirectionURIs");
                return;
            }
        } else {
            if (this.checkForbiddenScheme(redirectURIs, "https")) {
                this.log.warn("{} https-scheme is not allowed for a native application", (Object)this.getLogPrefix());
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidRedirectionURIs");
                return;
            }
            for (URI redirectUri : redirectURIs) {
                String scheme = redirectUri.getScheme();
                if (scheme.equalsIgnoreCase("http") && !redirectUri.getHost().equalsIgnoreCase("localhost")) {
                    this.log.warn("{} http-scheme is only allowed to localhost for a native application", (Object)this.getLogPrefix());
                    ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidRedirectionURIs");
                    return;
                }
                this.log.debug("{} Accepting a redirect URI {} for a native application", (Object)this.getLogPrefix(), (Object)redirectUri);
            }
        }
        this.log.debug("{} Redirect URIs ({}) checked", (Object)this.getLogPrefix(), (Object)redirectURIs.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean verifySectorIdUri(URI sectorIdUri, Set<URI> redirectURIs) {
        List parsedUris;
        String output;
        HttpResponse response;
        try {
            HttpUriRequest get = RequestBuilder.get().setUri(sectorIdUri).build();
            HttpClientContext clientContext = HttpClientContext.create();
            HttpClientSecuritySupport.marshalSecurityParameters((HttpClientContext)clientContext, (HttpClientSecurityParameters)this.httpClientSecurityParameters, (boolean)true);
            HttpClientSecuritySupport.addDefaultTLSTrustEngineCriteria((HttpClientContext)clientContext, (HttpUriRequest)get);
            response = this.httpClient.execute(get, (HttpContext)clientContext);
            HttpClientSecuritySupport.checkTLSCredentialEvaluated((HttpClientContext)clientContext, (String)get.getURI().getScheme());
        }
        catch (Exception e) {
            this.log.error("{} Could not get the sector_identifier_uri contents from {}", new Object[]{this.getLogPrefix(), sectorIdUri, e});
            return false;
        }
        if (response == null) {
            this.log.error("{} Could not get the sector_identifier_uri contents from {}", (Object)this.getLogPrefix(), (Object)sectorIdUri);
            return false;
        }
        try {
            output = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8");
        }
        catch (IOException | ParseException e) {
            this.log.error("{} Could not parse the sector_identifier_uri contents from {}", (Object)this.getLogPrefix(), (Object)sectorIdUri);
            boolean bl = false;
            return bl;
        }
        finally {
            EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
        }
        this.log.trace("{} Fetched the following response body: {}", (Object)this.getLogPrefix(), (Object)output);
        Type listType = new TypeToken<ArrayList<URI>>(){}.getType();
        try {
            parsedUris = (List)new Gson().fromJson(output, listType);
        }
        catch (JsonSyntaxException e) {
            this.log.error("{} Could not parse the sector_identifier_uri contents from {}", (Object)this.getLogPrefix(), (Object)sectorIdUri);
            return false;
        }
        if (parsedUris == null) {
            this.log.error("{} sector_identifier_uris contents is empty, no URLs included: {}", (Object)this.getLogPrefix(), (Object)output);
            return false;
        }
        for (URI redirectUri : redirectURIs) {
            if (!parsedUris.contains(redirectUri)) {
                this.log.error("{} Redirect URI {} was not found from the sector_identifier_uris", (Object)this.getLogPrefix(), (Object)redirectUri);
                return false;
            }
            this.log.trace("{} Redirect URI was validated against the sector_identifier_uris", (Object)this.getLogPrefix());
        }
        return true;
    }

    protected boolean checkScheme(Set<URI> redirectURIs, String scheme) {
        for (URI redirectUri : redirectURIs) {
            if (redirectUri.getScheme().equals(scheme)) continue;
            this.log.trace("{} Found '{}' as the scheme in the redirect URI, all should be {}", new Object[]{this.getLogPrefix(), redirectUri.getScheme(), scheme});
            return false;
        }
        return true;
    }

    protected boolean checkForbiddenScheme(Set<URI> redirectURIs, String scheme) {
        for (URI redirectUri : redirectURIs) {
            if (!redirectUri.getScheme().equals(scheme)) continue;
            this.log.trace("{} Found forbidden '{}' as the scheme in the redirect URI {}", new Object[]{this.getLogPrefix(), scheme, redirectUri});
            return true;
        }
        return false;
    }

    protected boolean checkForbiddenHostname(Set<URI> redirectURIs, String hostname) {
        for (URI redirectUri : redirectURIs) {
            if (!hostname.equalsIgnoreCase(redirectUri.getHost())) continue;
            this.log.trace("{} Found forbidden {} as the hostname in the redirect URIs", (Object)this.getLogPrefix(), (Object)hostname);
            return true;
        }
        return false;
    }
}

