/*
 * Decompiled with CFR 0.152.
 */
package org.geant.idpextension.oidc.profile.impl;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.profile.AbstractProfileAction;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import org.geant.idpextension.oidc.messaging.OIDCWebFingerRequest;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CheckWebFingerRel
extends AbstractProfileAction {
    @Nonnull
    @NotEmpty
    public static final String OPENID_REL = "http://openid.net/specs/connect/1.0/issuer";
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(CheckWebFingerRel.class);
    @Nullable
    private OIDCWebFingerRequest request;

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        if (profileRequestContext.getInboundMessageContext() == null) {
            this.log.debug("{} No inbound message context associated with this profile request", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
            return false;
        }
        Object message = profileRequestContext.getInboundMessageContext().getMessage();
        if (message == null || !(message instanceof OIDCWebFingerRequest)) {
            this.log.debug("{} No inbound message associated with this profile request", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessageContext");
            return false;
        }
        this.request = (OIDCWebFingerRequest)message;
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!OPENID_REL.equals(this.request.getRel())) {
            this.log.warn("{} Unsupported rel in the WebFinger request message: {}", (Object)this.getLogPrefix(), (Object)this.request.getRel());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidWebFingerRel");
        }
    }
}

