/*
 * Decompiled with CFR 0.152.
 */
package org.geant.idpextension.oidc.profile.impl;

import com.nimbusds.jose.EncryptionMethod;
import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWEAlgorithm;
import com.nimbusds.jose.JWEEncrypter;
import com.nimbusds.jose.JWEHeader;
import com.nimbusds.jose.JWEObject;
import com.nimbusds.jose.Payload;
import com.nimbusds.jose.crypto.AESEncrypter;
import com.nimbusds.jose.crypto.ECDHEncrypter;
import com.nimbusds.jose.crypto.RSAEncrypter;
import com.nimbusds.jwt.EncryptedJWT;
import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.SignedJWT;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.text.ParseException;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.profile.context.RelyingPartyContext;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.geant.idpextension.oidc.profile.impl.AbstractOIDCResponseAction;
import org.geant.idpextension.oidc.security.impl.CredentialConversionUtil;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.saml.saml2.profile.context.EncryptionContext;
import org.opensaml.security.credential.Credential;
import org.opensaml.xmlsec.EncryptionParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EncryptProcessedToken
extends AbstractOIDCResponseAction {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(EncryptProcessedToken.class);
    @Nonnull
    private Function<ProfileRequestContext, EncryptionContext> encryptionContextLookupStrategy = new ChildContextLookup(EncryptionContext.class).compose((Function)new ChildContextLookup(RelyingPartyContext.class));
    @Nullable
    private EncryptionParameters params;
    @Nullable
    private Payload payload;

    public void setEncryptionContextLookupStrategy(@Nonnull Function<ProfileRequestContext, EncryptionContext> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.encryptionContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"EncryptionContext lookup strategy cannot be null");
    }

    @Override
    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        EncryptionContext encryptCtx = this.encryptionContextLookupStrategy.apply(profileRequestContext);
        if (encryptCtx == null) {
            this.log.error("{} No EncryptionContext returned by lookup strategy", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
            return false;
        }
        this.params = encryptCtx.getAssertionEncryptionParameters();
        if (this.params == null) {
            this.log.debug("{} No Encryption parameters, nothing to do", (Object)this.getLogPrefix());
            return false;
        }
        if (this.getOidcResponseContext().getProcessedToken() != null) {
            this.payload = new Payload((SignedJWT)this.getOidcResponseContext().getProcessedToken());
        } else if (this.getOidcResponseContext().getUserInfo() != null) {
            this.payload = new Payload(this.getOidcResponseContext().getUserInfo().toJSONObject());
        }
        if (this.payload == null) {
            this.log.error("{} Instructed to encrypt but no plain text source available", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"UnableToEncrypt");
            return false;
        }
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        JWEAlgorithm encAlg = JWEAlgorithm.parse((String)this.params.getKeyTransportEncryptionAlgorithm());
        Credential credential = this.params.getKeyTransportEncryptionCredential();
        EncryptionMethod encEnc = EncryptionMethod.parse((String)this.params.getDataEncryptionAlgorithm());
        String kid = CredentialConversionUtil.resolveKid(credential);
        this.log.debug("{} encrypting with key {} and params alg: {} enc: {}", new Object[]{this.getLogPrefix(), kid, encAlg.getName(), encEnc.getName()});
        JWEObject jweObject = new JWEObject(new JWEHeader.Builder(encAlg, encEnc).contentType("JWT").keyID(kid).build(), this.payload);
        try {
            if (JWEAlgorithm.Family.RSA.contains((Object)encAlg)) {
                jweObject.encrypt((JWEEncrypter)new RSAEncrypter((RSAPublicKey)credential.getPublicKey()));
            } else if (JWEAlgorithm.Family.ECDH_ES.contains((Object)encAlg)) {
                jweObject.encrypt((JWEEncrypter)new ECDHEncrypter((ECPublicKey)credential.getPublicKey()));
            } else if (JWEAlgorithm.Family.SYMMETRIC.contains((Object)encAlg)) {
                jweObject.encrypt((JWEEncrypter)new AESEncrypter(credential.getSecretKey()));
            } else {
                this.log.error("{} Unsupported algorithm {}", (Object)this.getLogPrefix(), (Object)encAlg.getName());
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"UnableToEncrypt");
            }
            this.getOidcResponseContext().setProcessedToken((JWT)EncryptedJWT.parse((String)jweObject.serialize()));
        }
        catch (JOSEException | ParseException e) {
            this.log.error("{} Encryption failed {}", (Object)this.getLogPrefix(), (Object)e.getMessage());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"UnableToEncrypt");
        }
    }
}

