/*
 * Decompiled with CFR 0.152.
 */
package org.geant.idpextension.oidc.profile.impl;

import com.nimbusds.jwt.JWT;
import com.nimbusds.oauth2.sdk.token.AccessToken;
import com.nimbusds.openid.connect.sdk.OIDCTokenResponse;
import com.nimbusds.openid.connect.sdk.token.OIDCTokens;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.geant.idpextension.oidc.profile.impl.AbstractOIDCTokenResponseAction;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FormOutboundTokenResponseMessage
extends AbstractOIDCTokenResponseAction {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(FormOutboundTokenResponseMessage.class);
    @Nullable
    private AccessToken accessToken;
    @Nullable
    private JWT idToken;

    @Override
    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            this.log.error("{} pre-execute failed", (Object)this.getLogPrefix());
            return false;
        }
        this.accessToken = this.getOidcResponseContext().getAccessToken();
        if (this.accessToken == null) {
            this.log.error("{} unable to provide access token (required)", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
            return false;
        }
        this.idToken = this.getOidcResponseContext().getProcessedToken();
        if (this.idToken == null) {
            this.log.error("{} unable to provide id token (required)", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
            return false;
        }
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        OIDCTokenResponse resp = new OIDCTokenResponse(new OIDCTokens(this.idToken, this.accessToken, this.getOidcResponseContext().getRefreshToken()));
        profileRequestContext.getOutboundMessageContext().setMessage((Object)resp);
    }
}

