/*
 * Decompiled with CFR 0.152.
 */
package org.geant.idpextension.oidc.profile.impl;

import com.nimbusds.openid.connect.sdk.Prompt;
import java.time.Duration;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.shibboleth.idp.authn.context.AuthenticationContext;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.geant.idpextension.oidc.profile.context.navigate.DefaultRequestLoginHintLookupFunction;
import org.geant.idpextension.oidc.profile.context.navigate.DefaultRequestMaxAgeLookupFunction;
import org.geant.idpextension.oidc.profile.context.navigate.DefaultRequestedPromptLookupFunction;
import org.geant.idpextension.oidc.profile.impl.AbstractOIDCAuthenticationRequestAction;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InitializeAuthenticationContext
extends AbstractOIDCAuthenticationRequestAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(InitializeAuthenticationContext.class);
    @Nonnull
    private Function<ProfileRequestContext, Prompt> promptLookupStrategy = new DefaultRequestedPromptLookupFunction();
    @Nonnull
    private Function<ProfileRequestContext, String> loginHintLookupStrategy = new DefaultRequestLoginHintLookupFunction();
    @Nonnull
    private Function<ProfileRequestContext, Duration> maxAgeLookupStrategy = new DefaultRequestMaxAgeLookupFunction();

    public void setPromptLookupStrategy(@Nonnull Function<ProfileRequestContext, Prompt> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.promptLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"PromptLookupStrategy lookup strategy cannot be null");
    }

    public void setLoginHintLookupStrategy(@Nonnull Function<ProfileRequestContext, String> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.loginHintLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"LoginHintLookupStrategy lookup strategy cannot be null");
    }

    public void setMaxAgeLookupStrategy(@Nonnull Function<ProfileRequestContext, Duration> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.maxAgeLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"MaxAgeLookupStrategy lookup strategy cannot be null");
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        String loginHint;
        Prompt prompt;
        this.log.debug("{} Initializing authentication context", (Object)this.getLogPrefix());
        AuthenticationContext authnCtx = new AuthenticationContext();
        Duration maxAge = this.maxAgeLookupStrategy.apply(profileRequestContext);
        if (maxAge != null) {
            if (maxAge.isZero()) {
                authnCtx.setMaxAge(Duration.ofSeconds(1L));
            } else {
                authnCtx.setMaxAge(maxAge);
            }
        }
        if ((prompt = this.promptLookupStrategy.apply(profileRequestContext)) != null) {
            authnCtx.setIsPassive(prompt.contains((Object)Prompt.Type.NONE));
            authnCtx.setForceAuthn(prompt.contains((Object)Prompt.Type.LOGIN));
        }
        if ((loginHint = this.loginHintLookupStrategy.apply(profileRequestContext)) != null) {
            authnCtx.setHintedName(loginHint);
        }
        profileRequestContext.addSubcontext((BaseContext)authnCtx, true);
        this.log.debug("{} Created authentication context: {}", (Object)this.getLogPrefix(), (Object)authnCtx);
    }
}

