/*
 * Decompiled with CFR 0.152.
 */
package org.geant.idpextension.oidc.profile.impl;

import com.nimbusds.langtag.LangTag;
import com.nimbusds.openid.connect.sdk.rp.OIDCClientMetadata;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.imageio.ImageIO;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.geant.idpextension.oidc.messaging.context.OIDCMetadataContext;
import org.geant.idpextension.oidc.profile.impl.AbstractInitializeOutboundResponseMessageContext;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.profile.context.navigate.InboundMessageContextLookup;
import org.opensaml.profile.context.navigate.OutboundMessageContextLookup;
import org.opensaml.saml.common.messaging.context.SAMLMetadataContext;
import org.opensaml.saml.common.messaging.context.SAMLPeerEntityContext;
import org.opensaml.saml.ext.saml2mdui.DisplayName;
import org.opensaml.saml.ext.saml2mdui.Logo;
import org.opensaml.saml.ext.saml2mdui.PrivacyStatementURL;
import org.opensaml.saml.ext.saml2mdui.UIInfo;
import org.opensaml.saml.ext.saml2mdui.impl.DisplayNameBuilder;
import org.opensaml.saml.ext.saml2mdui.impl.InformationURLBuilder;
import org.opensaml.saml.ext.saml2mdui.impl.LogoBuilder;
import org.opensaml.saml.ext.saml2mdui.impl.PrivacyStatementURLBuilder;
import org.opensaml.saml.ext.saml2mdui.impl.UIInfoBuilder;
import org.opensaml.saml.saml2.metadata.ContactPerson;
import org.opensaml.saml.saml2.metadata.ContactPersonTypeEnumeration;
import org.opensaml.saml.saml2.metadata.EmailAddress;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml.saml2.metadata.Extensions;
import org.opensaml.saml.saml2.metadata.RoleDescriptor;
import org.opensaml.saml.saml2.metadata.SPSSODescriptor;
import org.opensaml.saml.saml2.metadata.impl.ContactPersonBuilder;
import org.opensaml.saml.saml2.metadata.impl.EmailAddressBuilder;
import org.opensaml.saml.saml2.metadata.impl.EntityDescriptorBuilder;
import org.opensaml.saml.saml2.metadata.impl.ExtensionsBuilder;
import org.opensaml.saml.saml2.metadata.impl.SPSSODescriptorBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InitializeOutboundAuthenticationResponseMessageContext
extends AbstractInitializeOutboundResponseMessageContext {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(InitializeOutboundAuthenticationResponseMessageContext.class);
    @Nonnull
    private Function<ProfileRequestContext, SAMLMetadataContext> samlMetadataCtxCreateStrategy = new ChildContextLookup(SAMLMetadataContext.class, true).compose(new ChildContextLookup(SAMLPeerEntityContext.class, true).compose((Function)new OutboundMessageContextLookup()));
    @Nonnull
    private Function<ProfileRequestContext, OIDCMetadataContext> oidcMetadataCtxLookupStrategy = new ChildContextLookup(OIDCMetadataContext.class).compose((Function)new InboundMessageContextLookup());
    private OIDCMetadataContext oidcMetadataCtx;
    private String defaultLanguage = "en";

    @Nonnull
    public Function<ProfileRequestContext, SAMLMetadataContext> getSAMLMetadataContextCreateStrategy() {
        return this.samlMetadataCtxCreateStrategy;
    }

    public void setSAMLMetadataContextCreateStrategy(@Nonnull Function<ProfileRequestContext, SAMLMetadataContext> strgy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.samlMetadataCtxCreateStrategy = (Function)Constraint.isNotNull(strgy, (String)"Injected Metadata Strategy cannot be null");
    }

    @Nonnull
    public Function<ProfileRequestContext, OIDCMetadataContext> getOIDCMetadataContextLookupStrategy() {
        return this.oidcMetadataCtxLookupStrategy;
    }

    public void setOIDCMetadataContextLookupStrategy(@Nonnull Function<ProfileRequestContext, OIDCMetadataContext> strgy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.oidcMetadataCtxLookupStrategy = (Function)Constraint.isNotNull(strgy, (String)"Injected Metadata Strategy cannot be null");
    }

    public void setDefaultLanguage(@Nonnull String language) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.defaultLanguage = Constraint.isNotEmpty((String)language, (String)"The default language cannot be empty");
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        this.oidcMetadataCtx = this.oidcMetadataCtxLookupStrategy.apply(profileRequestContext);
        if (this.oidcMetadataCtx == null) {
            this.log.error("{} No OIDC metadata context", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessageContext");
            return false;
        }
        return true;
    }

    @Override
    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        PrivacyStatementURL url;
        super.doExecute(profileRequestContext);
        SAMLMetadataContext samlContext = this.samlMetadataCtxCreateStrategy.apply(profileRequestContext);
        EntityDescriptor entityDescriptor = new EntityDescriptorBuilder().buildObject();
        entityDescriptor.setEntityID(this.oidcMetadataCtx.getClientInformation().getID().getValue());
        OIDCClientMetadata oidcMetadata = this.oidcMetadataCtx.getClientInformation().getOIDCMetadata();
        SPSSODescriptor spDescriptor = new SPSSODescriptorBuilder().buildObject();
        UIInfo uiInfo = new UIInfoBuilder().buildObject();
        for (Object tag : oidcMetadata.getLogoURIEntries().keySet()) {
            Logo logo = new LogoBuilder().buildObject();
            logo.setXMLLang(tag == null ? this.defaultLanguage : tag.getLanguage());
            URI logoUri = oidcMetadata.getLogoURI((LangTag)tag);
            try {
                BufferedImage image = ImageIO.read(oidcMetadata.getLogoURI((LangTag)tag).toURL());
                if (image == null) continue;
                logo.setURI(logoUri.toString());
                logo.setWidth(Integer.valueOf(image.getWidth()));
                logo.setHeight(Integer.valueOf(image.getHeight()));
                uiInfo.getLogos().add(logo);
            }
            catch (IOException e) {
                this.log.warn("{} Could not load the image from the URI {}", (Object)this.getLogPrefix(), (Object)logoUri);
            }
        }
        for (Object tag : oidcMetadata.getPolicyURIEntries().keySet()) {
            url = new PrivacyStatementURLBuilder().buildObject();
            url.setXMLLang(tag == null ? this.defaultLanguage : tag.getLanguage());
            url.setURI(oidcMetadata.getPolicyURI((LangTag)tag).toString());
            uiInfo.getPrivacyStatementURLs().add(url);
        }
        for (Object tag : oidcMetadata.getTermsOfServiceURIEntries().keySet()) {
            url = new InformationURLBuilder().buildObject();
            url.setXMLLang(tag == null ? this.defaultLanguage : tag.getLanguage());
            url.setURI(oidcMetadata.getTermsOfServiceURI((LangTag)tag).toString());
            uiInfo.getInformationURLs().add(url);
        }
        List emails = oidcMetadata.getEmailContacts();
        if (emails != null) {
            for (String email : emails) {
                ContactPerson contactPerson = new ContactPersonBuilder().buildObject();
                contactPerson.setType(ContactPersonTypeEnumeration.SUPPORT);
                EmailAddress address = new EmailAddressBuilder().buildObject();
                address.setURI((String)(email.startsWith("mailto:") ? email : "mailto:" + email));
                contactPerson.getEmailAddresses().add(address);
                entityDescriptor.getContactPersons().add(contactPerson);
            }
        }
        for (LangTag tag : oidcMetadata.getNameEntries().keySet()) {
            DisplayName displayName = new DisplayNameBuilder().buildObject();
            displayName.setXMLLang(tag == null ? this.defaultLanguage : tag.getLanguage());
            displayName.setValue((String)oidcMetadata.getNameEntries().get(tag));
            uiInfo.getDisplayNames().add(displayName);
        }
        Extensions extensions = new ExtensionsBuilder().buildObject();
        extensions.getUnknownXMLObjects().add(uiInfo);
        spDescriptor.setExtensions(extensions);
        samlContext.setEntityDescriptor(entityDescriptor);
        samlContext.setRoleDescriptor((RoleDescriptor)spDescriptor);
    }
}

