/*
 * Decompiled with CFR 0.152.
 */
package org.geant.idpextension.oidc.profile.impl;

import com.nimbusds.openid.connect.sdk.rp.OIDCClientMetadata;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.shibboleth.idp.profile.AbstractProfileAction;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.geant.idpextension.oidc.messaging.context.OIDCClientRegistrationResponseContext;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InitializeOutboundRegistrationResponseMessageContext
extends AbstractProfileAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(InitializeOutboundRegistrationResponseMessageContext.class);
    @Nonnull
    private Function<MessageContext, OIDCClientRegistrationResponseContext> oidcResponseContextCreationStrategy = new ChildContextLookup(OIDCClientRegistrationResponseContext.class, true);

    public void setOIDCClientRegistrationResponseContextCreationStrategy(@Nonnull Function<MessageContext, OIDCClientRegistrationResponseContext> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.oidcResponseContextCreationStrategy = (Function)Constraint.isNotNull(strategy, (String)"OIDCClientRegistrationResponseContext creation strategy cannot be null");
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        MessageContext msgCtx = new MessageContext();
        OIDCClientRegistrationResponseContext oidcResponseCtx = this.oidcResponseContextCreationStrategy.apply(msgCtx);
        oidcResponseCtx.setClientMetadata(new OIDCClientMetadata());
        profileRequestContext.setOutboundMessageContext(msgCtx);
        this.log.debug("{} Initialized outbound message context", (Object)this.getLogPrefix());
    }
}

