/*
 * Decompiled with CFR 0.152.
 */
package org.geant.idpextension.oidc.profile.impl;

import javax.annotation.Nonnull;
import net.shibboleth.idp.authn.context.SubjectContext;
import org.geant.idpextension.oidc.profile.impl.AbstractOIDCTokenResponseAction;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InitializeSubjectContext
extends AbstractOIDCTokenResponseAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(InitializeSubjectContext.class);

    @Override
    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            this.log.error("{} pre-execute failed", (Object)this.getLogPrefix());
            return false;
        }
        if (this.getOidcResponseContext().getTokenClaimsSet() == null) {
            this.log.error("{} user principal not resolved from token", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessage");
            return false;
        }
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        SubjectContext subCtx = (SubjectContext)profileRequestContext.getSubcontext(SubjectContext.class, true);
        subCtx.setPrincipalName(this.getOidcResponseContext().getTokenClaimsSet().getPrincipal());
        this.log.debug("{} Created subject context {} for user {}", new Object[]{this.getLogPrefix(), subCtx, this.getOidcResponseContext().getTokenClaimsSet().getPrincipal()});
    }
}

