/*
 * Decompiled with CFR 0.152.
 */
package org.geant.idpextension.oidc.profile.impl;

import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.profile.AbstractProfileAction;
import net.shibboleth.idp.profile.context.RelyingPartyContext;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullAfterInit;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import net.shibboleth.utilities.java.support.resolver.Criterion;
import net.shibboleth.utilities.java.support.resolver.ResolverException;
import org.geant.idpextension.oidc.criterion.ClientInformationCriterion;
import org.geant.idpextension.oidc.messaging.context.OIDCMetadataContext;
import org.geant.idpextension.oidc.profile.context.navigate.DefaultOIDCMetadataContextLookupFunction;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.saml.saml2.profile.context.EncryptionContext;
import org.opensaml.xmlsec.EncryptionConfiguration;
import org.opensaml.xmlsec.EncryptionParameters;
import org.opensaml.xmlsec.EncryptionParametersResolver;
import org.opensaml.xmlsec.SecurityConfigurationSupport;
import org.opensaml.xmlsec.criterion.EncryptionConfigurationCriterion;
import org.opensaml.xmlsec.criterion.EncryptionOptionalCriterion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PopulateOIDCEncryptionParameters
extends AbstractProfileAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(PopulateOIDCEncryptionParameters.class);
    private boolean forDecryption;
    @Nonnull
    private Function<ProfileRequestContext, EncryptionContext> encryptionContextLookupStrategy;
    @NonnullAfterInit
    private Function<ProfileRequestContext, List<EncryptionConfiguration>> configurationLookupStrategy;
    @NonnullAfterInit
    private EncryptionParametersResolver encParamsresolver;
    @Nullable
    @NonnullElements
    private List<EncryptionConfiguration> encryptionConfigurations;
    @Nullable
    private Function<ProfileRequestContext, OIDCMetadataContext> oidcMetadataContextLookupStrategy = new DefaultOIDCMetadataContextLookupFunction();

    public PopulateOIDCEncryptionParameters() {
        this.encryptionContextLookupStrategy = new ChildContextLookup(EncryptionContext.class, true).compose((Function)new ChildContextLookup(RelyingPartyContext.class));
    }

    public void setForDecryption(boolean flag) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.forDecryption = flag;
    }

    public void setEncryptionContextLookupStrategy(@Nonnull Function<ProfileRequestContext, EncryptionContext> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.encryptionContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"EncryptionContext lookup strategy cannot be null");
    }

    public void setOIDCMetadataContextContextLookupStrategy(@Nonnull Function<ProfileRequestContext, OIDCMetadataContext> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.oidcMetadataContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)" OIDCMetadataContext lookup strategy cannot be null");
    }

    public void setConfigurationLookupStrategy(@Nonnull Function<ProfileRequestContext, List<EncryptionConfiguration>> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.configurationLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"EncryptionConfiguration lookup strategy cannot be null");
    }

    public void setEncryptionParametersResolver(@Nonnull EncryptionParametersResolver newResolver) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.encParamsresolver = (EncryptionParametersResolver)Constraint.isNotNull((Object)newResolver, (String)"EncryptionParametersResolver cannot be null");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.encParamsresolver == null) {
            throw new ComponentInitializationException("EncryptionParametersResolver cannot be null");
        }
        if (this.configurationLookupStrategy == null) {
            this.configurationLookupStrategy = new Function<ProfileRequestContext, List<EncryptionConfiguration>>(){

                @Override
                public List<EncryptionConfiguration> apply(ProfileRequestContext input) {
                    return Collections.singletonList(SecurityConfigurationSupport.getGlobalEncryptionConfiguration());
                }
            };
        }
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        this.log.debug("{} Resolving EncryptionParameters for request, purpose {}", (Object)this.getLogPrefix(), (Object)(this.forDecryption ? "request object decryption" : "response encryption"));
        EncryptionContext encryptCtx = this.encryptionContextLookupStrategy.apply(profileRequestContext);
        if (encryptCtx == null) {
            this.log.debug("{} No EncryptionContext returned by lookup strategy", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
            return;
        }
        try {
            this.encryptionConfigurations = this.configurationLookupStrategy.apply(profileRequestContext);
            if (this.encryptionConfigurations == null || this.encryptionConfigurations.isEmpty()) {
                throw new ResolverException("No EncryptionConfigurations returned by lookup strategy");
            }
            CriteriaSet criteria = this.buildCriteriaSet(profileRequestContext);
            EncryptionParameters params = (EncryptionParameters)this.encParamsresolver.resolveSingle((Object)criteria);
            this.log.debug("{} {} EncryptionParameters for {}", new Object[]{this.getLogPrefix(), params != null ? "Resolved" : "Failed to resolve", this.forDecryption ? "request object decryption" : "response encryption"});
            if (params != null) {
                if (this.forDecryption) {
                    encryptCtx.setAttributeEncryptionParameters(params);
                } else {
                    encryptCtx.setAssertionEncryptionParameters(params);
                }
                return;
            }
            EncryptionOptionalCriterion encryptionOptionalCrit = (EncryptionOptionalCriterion)criteria.get(EncryptionOptionalCriterion.class);
            if (encryptionOptionalCrit != null && encryptionOptionalCrit.isEncryptionOptional()) {
                this.log.debug("{} Encryption optional", (Object)this.getLogPrefix());
                return;
            }
        }
        catch (ResolverException e) {
            this.log.error("{} Error resolving EncryptionParameters", (Object)this.getLogPrefix(), (Object)e);
        }
        ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidSecurityConfiguration");
    }

    @Nonnull
    private CriteriaSet buildCriteriaSet(@Nonnull ProfileRequestContext profileRequestContext) {
        CriteriaSet criteria = new CriteriaSet(new Criterion[]{new EncryptionConfigurationCriterion(this.encryptionConfigurations)});
        OIDCMetadataContext oidcMetadataCtx = this.oidcMetadataContextLookupStrategy.apply(profileRequestContext);
        if (oidcMetadataCtx != null && oidcMetadataCtx.getClientInformation() != null) {
            this.log.debug("{} Adding oidc client information to resolution criteria for key transport / encryption algorithms", (Object)this.getLogPrefix());
            criteria.add((Object)new ClientInformationCriterion(oidcMetadataCtx.getClientInformation()));
        } else {
            this.log.debug("{} oidcMetadataCtx is null", (Object)this.getLogPrefix());
        }
        return criteria;
    }
}

