/*
 * Decompiled with CFR 0.152.
 */
package org.geant.idpextension.oidc.profile.impl;

import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullAfterInit;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import net.shibboleth.utilities.java.support.resolver.Criterion;
import net.shibboleth.utilities.java.support.resolver.ResolverException;
import org.geant.idpextension.oidc.criterion.ClientInformationCriterion;
import org.geant.idpextension.oidc.messaging.context.OIDCMetadataContext;
import org.geant.idpextension.oidc.profile.context.navigate.DefaultOIDCMetadataContextLookupFunction;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.messaging.context.navigate.ParentContextLookup;
import org.opensaml.messaging.handler.AbstractMessageHandler;
import org.opensaml.messaging.handler.MessageHandlerException;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.saml.common.messaging.context.SAMLMetadataContext;
import org.opensaml.saml.common.messaging.context.SAMLPeerEntityContext;
import org.opensaml.saml.criterion.RoleDescriptorCriterion;
import org.opensaml.xmlsec.SecurityConfigurationSupport;
import org.opensaml.xmlsec.SignatureSigningConfiguration;
import org.opensaml.xmlsec.SignatureSigningParameters;
import org.opensaml.xmlsec.SignatureSigningParametersResolver;
import org.opensaml.xmlsec.context.SecurityParametersContext;
import org.opensaml.xmlsec.criterion.SignatureSigningConfigurationCriterion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PopulateOIDCSignatureSigningParametersHandler
extends AbstractMessageHandler {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(PopulateOIDCSignatureSigningParametersHandler.class);
    @Nonnull
    private Function<MessageContext, SecurityParametersContext> securityParametersContextLookupStrategy = new ChildContextLookup(SecurityParametersContext.class, true);
    @Nullable
    private Function<MessageContext, SecurityParametersContext> existingParametersContextLookupStrategy;
    @NonnullAfterInit
    private Function<MessageContext, List<SignatureSigningConfiguration>> configurationLookupStrategy;
    @Nullable
    private Function<MessageContext, SAMLMetadataContext> metadataContextLookupStrategy;
    @NonnullAfterInit
    private SignatureSigningParametersResolver resolver;
    private boolean noResultIsError;
    @Nullable
    private Function<MessageContext, OIDCMetadataContext> oidcMetadataContextLookupStrategy = new DefaultOIDCMetadataContextLookupFunction().compose((Function)new ParentContextLookup(ProfileRequestContext.class));

    public PopulateOIDCSignatureSigningParametersHandler() {
        this.metadataContextLookupStrategy = new ChildContextLookup(SAMLMetadataContext.class).compose((Function)new ChildContextLookup(SAMLPeerEntityContext.class));
    }

    public void setSecurityParametersContextLookupStrategy(@Nonnull Function<MessageContext, SecurityParametersContext> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.securityParametersContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"SecurityParametersContext lookup strategy cannot be null");
    }

    public void setExistingParametersContextLookupStrategy(@Nullable Function<MessageContext, SecurityParametersContext> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.existingParametersContextLookupStrategy = strategy;
    }

    public void setMetadataContextLookupStrategy(@Nullable Function<MessageContext, SAMLMetadataContext> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.metadataContextLookupStrategy = strategy;
    }

    public void setConfigurationLookupStrategy(@Nonnull Function<MessageContext, List<SignatureSigningConfiguration>> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.configurationLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"SignatureSigningConfiguration lookup strategy cannot be null");
    }

    public void setSignatureSigningParametersResolver(@Nonnull SignatureSigningParametersResolver newResolver) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.resolver = (SignatureSigningParametersResolver)Constraint.isNotNull((Object)newResolver, (String)"SignatureSigningParametersResolver cannot be null");
    }

    public void setNoResultIsError(boolean flag) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.noResultIsError = flag;
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.resolver == null) {
            throw new ComponentInitializationException("SignatureSigningParametersResolver cannot be null");
        }
        if (this.configurationLookupStrategy == null) {
            this.configurationLookupStrategy = new Function<MessageContext, List<SignatureSigningConfiguration>>(){

                @Override
                public List<SignatureSigningConfiguration> apply(MessageContext input) {
                    return Collections.singletonList(SecurityConfigurationSupport.getGlobalSignatureSigningConfiguration());
                }
            };
        }
    }

    protected boolean doPreInvoke(@Nonnull MessageContext messageContext) throws MessageHandlerException {
        if (super.doPreInvoke(messageContext)) {
            this.log.debug("{} Signing enabled", (Object)this.getLogPrefix());
            return true;
        }
        this.log.debug("{} Signing not enabled", (Object)this.getLogPrefix());
        return false;
    }

    protected void doInvoke(@Nonnull MessageContext messageContext) throws MessageHandlerException {
        SAMLMetadataContext metadataCtx;
        SecurityParametersContext existingCtx;
        this.log.debug("{} Resolving SignatureSigningParameters for request", (Object)this.getLogPrefix());
        SecurityParametersContext paramsCtx = this.securityParametersContextLookupStrategy.apply(messageContext);
        if (paramsCtx == null) {
            this.log.debug("{} No SecurityParametersContext returned by lookup strategy", (Object)this.getLogPrefix());
            throw new MessageHandlerException("No SecurityParametersContext returned by lookup strategy");
        }
        if (this.existingParametersContextLookupStrategy != null && (existingCtx = this.existingParametersContextLookupStrategy.apply(messageContext)) != null && existingCtx.getSignatureSigningParameters() != null) {
            this.log.debug("{} Found existing SecurityParametersContext to copy from", (Object)this.getLogPrefix());
            paramsCtx.setSignatureSigningParameters(existingCtx.getSignatureSigningParameters());
            return;
        }
        List<SignatureSigningConfiguration> configs = this.configurationLookupStrategy.apply(messageContext);
        if (configs == null || configs.isEmpty()) {
            this.log.error("{} No SignatureSigningConfiguration returned by lookup strategy", (Object)this.getLogPrefix());
            throw new MessageHandlerException("No SignatureSigningConfiguration returned by lookup strategy");
        }
        CriteriaSet criteria = new CriteriaSet(new Criterion[]{new SignatureSigningConfigurationCriterion(configs)});
        if (this.metadataContextLookupStrategy != null && (metadataCtx = this.metadataContextLookupStrategy.apply(messageContext)) != null && metadataCtx.getRoleDescriptor() != null) {
            this.log.debug("{} Adding metadata to resolution criteria for signing/digest algorithms", (Object)this.getLogPrefix());
            criteria.add((Object)new RoleDescriptorCriterion(metadataCtx.getRoleDescriptor()));
        }
        if (this.oidcMetadataContextLookupStrategy != null) {
            OIDCMetadataContext oidcMetadataCtx = this.oidcMetadataContextLookupStrategy.apply(messageContext);
            if (oidcMetadataCtx != null && oidcMetadataCtx.getClientInformation() != null) {
                this.log.debug("{} Adding oidc client information to resolution criteria for signing/digest algorithms", (Object)this.getLogPrefix());
                criteria.add((Object)new ClientInformationCriterion(oidcMetadataCtx.getClientInformation()));
            } else {
                this.log.debug("{} oidcMetadataCtx is null", (Object)this.getLogPrefix());
            }
        } else {
            this.log.debug("{} oidcMetadataContextLookupStrategy is null", (Object)this.getLogPrefix());
        }
        try {
            SignatureSigningParameters params = (SignatureSigningParameters)this.resolver.resolveSingle((Object)criteria);
            if (params == null && this.noResultIsError) {
                this.log.error("Failed to resolve SignatureSigningParameters");
                throw new MessageHandlerException("Failed to resolve SignatureSigningParameters");
            }
            this.log.debug("{} {} SignatureSigningParameters", (Object)this.getLogPrefix(), (Object)(params != null ? "Resolved" : "Failed to resolve"));
            paramsCtx.setSignatureSigningParameters(params);
        }
        catch (ResolverException e) {
            this.log.error("{} Error resolving SignatureSigningParameters", (Object)this.getLogPrefix(), (Object)e);
            throw new MessageHandlerException("Error resolving SignatureSigningParameters", (Exception)((Object)e));
        }
    }
}

