/*
 * Decompiled with CFR 0.152.
 */
package org.geant.idpextension.oidc.profile.impl;

import com.nimbusds.openid.connect.sdk.ClaimsRequest;
import com.nimbusds.openid.connect.sdk.claims.ACR;
import com.nimbusds.openid.connect.sdk.claims.ClaimRequirement;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.authn.context.AuthenticationContext;
import net.shibboleth.idp.authn.context.PreferredPrincipalContext;
import net.shibboleth.idp.authn.context.RequestedPrincipalContext;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.geant.idpextension.oidc.authn.principal.AuthenticationContextClassReferencePrincipal;
import org.geant.idpextension.oidc.config.navigate.AcrClaimAlwaysEssentialLookupFunction;
import org.geant.idpextension.oidc.profile.context.navigate.DefaultRequestedAcrLookupFunction;
import org.geant.idpextension.oidc.profile.impl.AbstractOIDCAuthenticationResponseAction;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.saml.saml2.core.AuthnContextComparisonTypeEnumeration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessRequestedAuthnContext
extends AbstractOIDCAuthenticationResponseAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(ProcessRequestedAuthnContext.class);
    @Nonnull
    private Function<ProfileRequestContext, List<ACR>> acrLookupStrategy = new DefaultRequestedAcrLookupFunction();
    @Nonnull
    private Predicate<ProfileRequestContext> acrAlwaysEssentialLookupStrategy = new AcrClaimAlwaysEssentialLookupFunction();
    @Nullable
    private AuthenticationContext authenticationContext;
    private List<ACR> acrValues;
    private ClaimsRequest.Entry acrClaim;

    public void setAcrLookupStrategy(@Nonnull Function<ProfileRequestContext, List<ACR>> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.acrLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Acr lookup strategy cannot be null");
    }

    public void setAcrAlwaysEssentialLookupStrategy(@Nonnull Predicate<ProfileRequestContext> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.acrAlwaysEssentialLookupStrategy = (Predicate)Constraint.isNotNull(strategy, (String)"AcrAlwaysEssentialLookupStrategy lookup strategy cannot be null");
    }

    @Override
    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        this.acrValues = this.acrLookupStrategy.apply(profileRequestContext);
        if (this.getOidcResponseContext().getRequestedClaims() != null && this.getOidcResponseContext().getRequestedClaims().getIDTokenClaims() != null) {
            for (ClaimsRequest.Entry entry : this.getOidcResponseContext().getRequestedClaims().getIDTokenClaims()) {
                if (!"acr".equals(entry.getClaimName())) continue;
                this.acrClaim = entry;
                break;
            }
        }
        if ((this.acrValues == null || this.acrValues.isEmpty()) && (this.acrClaim == null || this.acrClaim.getValues() == null && this.acrClaim.getValue() == null)) {
            this.log.debug("No acr values nor acr claim values in request, nothing to do");
            return false;
        }
        this.authenticationContext = (AuthenticationContext)profileRequestContext.getSubcontext(AuthenticationContext.class);
        if (this.authenticationContext == null) {
            this.log.error("{} No authentication context", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidAuthenticationContext");
            return false;
        }
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        ArrayList<AuthenticationContextClassReferencePrincipal> principals = new ArrayList<AuthenticationContextClassReferencePrincipal>();
        boolean isEssential = false;
        if (this.acrValues != null && !this.acrValues.isEmpty()) {
            for (ACR acr : this.acrValues) {
                this.log.debug("{} Located acr value {} in request", (Object)this.getLogPrefix(), (Object)acr.getValue());
                principals.add(new AuthenticationContextClassReferencePrincipal(acr.getValue()));
            }
        } else if (this.acrClaim != null && this.acrClaim.getValue() != null) {
            isEssential = this.acrClaim.getClaimRequirement().equals((Object)ClaimRequirement.ESSENTIAL);
            this.log.debug("{} Located {} acr claim {} in id token section of claims request", new Object[]{this.getLogPrefix(), this.acrClaim.getClaimRequirement().toString(), this.acrClaim.getValue()});
            principals.add(new AuthenticationContextClassReferencePrincipal(this.acrClaim.getValue()));
        } else if (!(this.acrClaim == null || this.acrClaim.getValues() != null && this.acrClaim.getValues().isEmpty())) {
            isEssential = this.acrClaim.getClaimRequirement().equals((Object)ClaimRequirement.ESSENTIAL);
            for (String acr : this.acrClaim.getValues()) {
                this.log.debug("{} Located {} acr claim {} in id token section of claims request", new Object[]{this.getLogPrefix(), this.acrClaim.getClaimRequirement().toString(), acr});
                principals.add(new AuthenticationContextClassReferencePrincipal(acr));
            }
        }
        if (principals.isEmpty()) {
            this.log.debug("{} request did not contain any acr values, nothing to do", (Object)this.getLogPrefix());
            return;
        }
        if (isEssential || this.acrAlwaysEssentialLookupStrategy.test(profileRequestContext)) {
            RequestedPrincipalContext rpCtx = new RequestedPrincipalContext();
            rpCtx.setOperator(AuthnContextComparisonTypeEnumeration.EXACT.toString());
            rpCtx.setRequestedPrincipals(principals);
            this.authenticationContext.addSubcontext((BaseContext)rpCtx, true);
            this.log.debug("{} Created requested principal context", (Object)this.getLogPrefix());
            return;
        }
        PreferredPrincipalContext ppCtx = new PreferredPrincipalContext();
        ppCtx.setPreferredPrincipals(principals);
        this.authenticationContext.addSubcontext((BaseContext)ppCtx, true);
        this.log.debug("{} Created preferred principal context", (Object)this.getLogPrefix());
    }
}

