/*
 * Decompiled with CFR 0.152.
 */
package org.geant.idpextension.oidc.profile.impl;

import com.nimbusds.oauth2.sdk.Scope;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.geant.idpextension.oidc.messaging.context.OIDCAuthenticationResponseTokenClaimsContext;
import org.geant.idpextension.oidc.profile.context.navigate.OIDCAuthenticationResponseContextLookupFunction;
import org.geant.idpextension.oidc.profile.impl.AbstractOIDCTokenResponseAction;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReduceValidatedScope
extends AbstractOIDCTokenResponseAction {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(ReduceValidatedScope.class);
    @Nonnull
    private Function<ProfileRequestContext, OIDCAuthenticationResponseTokenClaimsContext> tokenClaimsContextLookupStrategy = new ChildContextLookup(OIDCAuthenticationResponseTokenClaimsContext.class).compose((Function)new OIDCAuthenticationResponseContextLookupFunction());
    @Nullable
    private OIDCAuthenticationResponseTokenClaimsContext tokenClaimsCtx;

    ReduceValidatedScope() {
    }

    public void setOIDCAuthenticationResponseTokenClaimsContextLookupStrategy(@Nonnull Function<ProfileRequestContext, OIDCAuthenticationResponseTokenClaimsContext> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.tokenClaimsContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"OIDCAuthenticationResponseTokenClaimsContextt lookup strategy cannot be null");
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        Scope requestedScope = this.getTokenRequest().getScope();
        if (requestedScope == null) {
            return;
        }
        List validatedScopes = this.getOidcResponseContext().getScope().toStringList();
        this.log.debug("{} Original scope {}", (Object)this.getLogPrefix(), (Object)this.getOidcResponseContext().getScope().toString());
        validatedScopes.retainAll(requestedScope.toStringList());
        Scope reducedScope = new Scope();
        for (String scope : validatedScopes) {
            reducedScope.add(scope);
        }
        this.log.debug("{} Reduced scope {}", (Object)this.getLogPrefix(), (Object)reducedScope.toString());
        if (!reducedScope.equals((Object)this.getOidcResponseContext().getScope())) {
            this.getOidcResponseContext().setScope(reducedScope);
            this.tokenClaimsCtx = this.tokenClaimsContextLookupStrategy.apply(profileRequestContext);
            if (this.tokenClaimsCtx != null) {
                this.log.debug("{} Removing token delivery attributes due to reduced scope", (Object)this.getLogPrefix());
                BaseContext parent = this.tokenClaimsCtx.getParent();
                parent.removeSubcontext((BaseContext)this.tokenClaimsCtx);
            }
        }
    }
}

